/*
 * Decompiled with CFR 0.152.
 */
package com.swirlds.common.threading;

import com.swirlds.common.threading.InterruptableRunnable;
import com.swirlds.common.threading.QueueThread;
import com.swirlds.common.threading.QueueThreadHandler;
import com.swirlds.common.threading.QueueThreadThreshold;
import com.swirlds.common.threading.StoppableThreadConfiguration;
import java.time.Duration;
import java.util.LinkedList;
import java.util.List;
import java.util.concurrent.BlockingQueue;
import java.util.function.Consumer;
import java.util.function.Predicate;

public class QueueThreadConfiguration<T> {
    private int capacity = 100;
    private int maxBufferSize = 10000;
    private QueueThreadHandler<T> handler;
    private final List<QueueThreadThreshold> thresholds = new LinkedList<QueueThreadThreshold>();
    private InterruptableRunnable waitForItemRunnable;
    private BlockingQueue<T> queue;
    private boolean interruptable = false;
    private final StoppableThreadConfiguration<InterruptableRunnable> stoppableThreadConfiguration = new StoppableThreadConfiguration();
    public static final int DEFAULT_CAPACITY = 100;
    public static final int DEFAULT_MAX_BUFFER_SIZE = 10000;
    public static final int UNLIMITED_CAPACITY = -1;

    public QueueThreadConfiguration() {
        this.stoppableThreadConfiguration.setPausable(true);
    }

    public QueueThread<T> build() {
        return this.build(false);
    }

    public QueueThread<T> build(boolean start) {
        if (this.handler == null) {
            throw new NullPointerException("handler must not be null");
        }
        QueueThread thread = new QueueThread(this);
        if (start) {
            thread.start();
        }
        return thread;
    }

    public int getCapacity() {
        return this.capacity;
    }

    public QueueThreadConfiguration<T> setCapacity(int capacity) {
        this.capacity = capacity;
        return this;
    }

    public QueueThreadConfiguration<T> setUnlimitedCapacity() {
        this.capacity = -1;
        return this;
    }

    public int getMaxBufferSize() {
        return this.maxBufferSize;
    }

    public QueueThreadConfiguration<T> setMaxBufferSize(int maxBufferSize) {
        this.maxBufferSize = maxBufferSize;
        return this;
    }

    public QueueThreadHandler<T> getHandler() {
        return this.handler;
    }

    public QueueThreadConfiguration<T> setHandler(QueueThreadHandler<T> handler) {
        this.handler = handler;
        return this;
    }

    public ThreadGroup getThreadGroup() {
        return this.stoppableThreadConfiguration.getThreadGroup();
    }

    public QueueThreadConfiguration<T> setThreadGroup(ThreadGroup threadGroup) {
        this.stoppableThreadConfiguration.setThreadGroup(threadGroup);
        return this;
    }

    public boolean isDaemon() {
        return this.stoppableThreadConfiguration.isDaemon();
    }

    public QueueThreadConfiguration<T> setDaemon(boolean daemon) {
        this.stoppableThreadConfiguration.setDaemon(daemon);
        return this;
    }

    public int getPriority() {
        return this.stoppableThreadConfiguration.getPriority();
    }

    public QueueThreadConfiguration<T> setPriority(int priority) {
        this.stoppableThreadConfiguration.setPriority(priority);
        return this;
    }

    public ClassLoader getContextClassLoader() {
        return this.stoppableThreadConfiguration.getContextClassLoader();
    }

    public QueueThreadConfiguration<T> setContextClassLoader(ClassLoader contextClassLoader) {
        this.stoppableThreadConfiguration.setContextClassLoader(contextClassLoader);
        return this;
    }

    public Thread.UncaughtExceptionHandler getExceptionHandler() {
        return this.stoppableThreadConfiguration.getExceptionHandler();
    }

    public QueueThreadConfiguration<T> setExceptionHandler(Thread.UncaughtExceptionHandler exceptionHandler) {
        this.stoppableThreadConfiguration.setExceptionHandler(exceptionHandler);
        return this;
    }

    public long getNodeId() {
        return this.stoppableThreadConfiguration.getNodeId();
    }

    public QueueThreadConfiguration<T> setNodeId(long nodeId) {
        this.stoppableThreadConfiguration.setNodeId(nodeId);
        return this;
    }

    public String getComponent() {
        return this.stoppableThreadConfiguration.getComponent();
    }

    public QueueThreadConfiguration<T> setComponent(String component) {
        this.stoppableThreadConfiguration.setComponent(component);
        return this;
    }

    public String getThreadName() {
        return this.stoppableThreadConfiguration.getThreadName();
    }

    public QueueThreadConfiguration<T> setThreadName(String threadName) {
        this.stoppableThreadConfiguration.setThreadName(threadName);
        return this;
    }

    public long getOtherNodeId() {
        return this.stoppableThreadConfiguration.getOtherNodeId();
    }

    public QueueThreadConfiguration<T> setOtherNodeId(long otherNodeId) {
        this.stoppableThreadConfiguration.setOtherNodeId(otherNodeId);
        return this;
    }

    public Duration getHangingThreadPeriod() {
        return this.stoppableThreadConfiguration.getHangingThreadPeriod();
    }

    public QueueThreadConfiguration<T> setHangingThreadPeriod(Duration hangingThreadPeriod) {
        this.stoppableThreadConfiguration.setHangingThreadPeriod(hangingThreadPeriod);
        return this;
    }

    public QueueThreadConfiguration<T> setWaitForItemRunnable(InterruptableRunnable waitForItemRunnable) {
        this.waitForItemRunnable = waitForItemRunnable;
        return this;
    }

    public QueueThreadConfiguration<T> setQueue(BlockingQueue<T> queue) {
        this.queue = queue;
        return this;
    }

    public QueueThreadConfiguration<T> addThreshold(Predicate<Integer> threshold, Consumer<Integer> action, Duration minimumPeriod) {
        this.thresholds.add(new QueueThreadThreshold(threshold, action, minimumPeriod));
        return this;
    }

    public List<QueueThreadThreshold> getThresholds() {
        return this.thresholds;
    }

    StoppableThreadConfiguration<InterruptableRunnable> getStoppableThreadConfiguration() {
        return this.stoppableThreadConfiguration;
    }

    public Duration getMinimumPeriod() {
        return this.stoppableThreadConfiguration.getMinimumPeriod();
    }

    public QueueThreadConfiguration<T> setMinimumPeriod(Duration minimumPeriod) {
        this.stoppableThreadConfiguration.setMinimumPeriod(minimumPeriod);
        return this;
    }

    public double getMaximumRate() {
        return this.stoppableThreadConfiguration.getMaximumRate();
    }

    public QueueThreadConfiguration<T> setMaximumRate(double hz) {
        this.stoppableThreadConfiguration.setMaximumRate(hz);
        return this;
    }

    public InterruptableRunnable getWaitForItemRunnable() {
        return this.waitForItemRunnable;
    }

    public BlockingQueue<T> getQueue() {
        return this.queue;
    }

    public QueueThreadConfiguration<T> setInterruptable(boolean interruptable) {
        this.interruptable = interruptable;
        return this;
    }

    public boolean isInterruptable() {
        return this.interruptable;
    }
}

