/*
 * Decompiled with CFR 0.152.
 */
package com.swirlds.common.threading;

import java.time.Duration;
import java.time.Instant;
import java.util.function.Consumer;
import java.util.function.Predicate;

public class QueueThreadThreshold {
    private final Predicate<Integer> threshold;
    private final Consumer<Integer> action;
    private final Duration minimumPeriod;
    private Instant previousTime;

    public QueueThreadThreshold(Predicate<Integer> threshold, Consumer<Integer> action, Duration minimumPeriod) {
        this.threshold = threshold;
        this.action = action;
        this.minimumPeriod = minimumPeriod;
        this.previousTime = Instant.ofEpochMilli(0L);
    }

    public void checkValue(Instant now, int value) {
        if (Duration.between(this.previousTime, now).toMillis() > this.minimumPeriod.toMillis() && this.threshold.test(value)) {
            this.action.accept(value);
            this.previousTime = now;
        }
    }
}

