/*
 * Decompiled with CFR 0.152.
 */
package com.swirlds.common.threading;

import com.swirlds.common.futures.ConcurrentFuturePool;
import com.swirlds.common.threading.ThreadConfiguration;
import com.swirlds.logging.LogMarker;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class StandardWorkGroup {
    private static final Logger LOG = LogManager.getLogger(StandardWorkGroup.class);
    private static final String DEFAULT_TASK_NAME = "IDLE";
    private final String groupName;
    private final ExecutorService executorService;
    private final ConcurrentFuturePool<Void> futures;
    private volatile boolean hasExceptions;
    private final AtomicBoolean firstException = new AtomicBoolean(true);
    private final Runnable onException;

    public StandardWorkGroup(String groupName, Runnable abortAction) {
        this.groupName = groupName;
        this.futures = new ConcurrentFuturePool(this::handleError);
        this.onException = abortAction;
        ThreadConfiguration configuration = new ThreadConfiguration().setComponent("work group " + groupName).setThreadName(DEFAULT_TASK_NAME);
        this.executorService = Executors.newCachedThreadPool(configuration.buildFactory());
    }

    public void shutdown() {
        this.executorService.shutdown();
    }

    public boolean isShutdown() {
        return this.executorService.isShutdown();
    }

    public boolean isTerminated() {
        return this.executorService.isTerminated();
    }

    public void execute(Runnable operation) {
        this.futures.add(this.executorService.submit(operation));
    }

    public void execute(String taskName, Runnable operation) {
        Runnable wrapper = () -> {
            String originalThreadName = Thread.currentThread().getName();
            String newThreadName = originalThreadName.replaceFirst(DEFAULT_TASK_NAME, taskName);
            try {
                Thread.currentThread().setName(newThreadName);
                operation.run();
            }
            finally {
                Thread.currentThread().setName(originalThreadName);
            }
        };
        this.execute(wrapper);
    }

    public boolean hasExceptions() {
        return this.hasExceptions;
    }

    public void waitForTermination() throws InterruptedException {
        this.futures.waitForCompletion();
        this.executorService.shutdown();
        while (!this.executorService.isTerminated() && !this.executorService.awaitTermination(10L, TimeUnit.MILLISECONDS)) {
        }
    }

    private void handleError(Throwable ex) {
        if (this.onException != null && this.firstException.getAndSet(false)) {
            this.onException.run();
        }
        if (!(ex instanceof InterruptedException)) {
            LOG.error(LogMarker.EXCEPTION.getMarker(), "Work Group Exception [ groupName = {} ]", (Object)this.groupName, (Object)ex);
            this.hasExceptions = true;
            this.executorService.shutdownNow();
        }
    }
}

