/*
 * Decompiled with CFR 0.152.
 */
package com.swirlds.common.threading;

import com.swirlds.common.threading.InterruptableRunnable;
import com.swirlds.common.threading.ThreadConfiguration;
import com.swirlds.common.threading.TypedStoppableThread;
import com.swirlds.common.threading.internal.StoppableThreadImpl;
import java.time.Duration;

public class StoppableThreadConfiguration<T extends InterruptableRunnable> {
    private boolean interruptable = true;
    private int joinWaitMs = 50;
    private boolean pausable = false;
    private Duration minimumPeriod;
    private T work;
    private InterruptableRunnable finalCycleWork;
    private Duration hangingThreadPeriod;
    private final ThreadConfiguration threadConfiguration = new ThreadConfiguration();
    public static final boolean DEFAULT_INTERRUPTABLE = true;
    public static final boolean DEFAULT_PAUSABLE = false;
    public static final int DEFAULT_JOIN_WAIT_MS = 50;
    public static final Duration DEFAULT_HANGING_PERIOD = Duration.ofMinutes(1L);

    public StoppableThreadConfiguration() {
        this.hangingThreadPeriod = DEFAULT_HANGING_PERIOD;
    }

    public TypedStoppableThread<T> build() {
        return this.build(false);
    }

    public TypedStoppableThread<T> build(boolean start) {
        StoppableThreadImpl thread = new StoppableThreadImpl(this);
        if (start) {
            thread.start();
        }
        return thread;
    }

    public InterruptableRunnable getFinalCycleWork() {
        return this.finalCycleWork;
    }

    public StoppableThreadConfiguration<T> setFinalCycleWork(InterruptableRunnable finalCycleWork) {
        this.finalCycleWork = finalCycleWork;
        return this;
    }

    public T getWork() {
        return this.work;
    }

    public StoppableThreadConfiguration<T> setWork(T work) {
        this.work = work;
        return this;
    }

    public boolean isInterruptable() {
        return this.interruptable;
    }

    public StoppableThreadConfiguration<T> setInterruptable(boolean interruptable) {
        this.interruptable = interruptable;
        return this;
    }

    public boolean isPausable() {
        return this.pausable;
    }

    public StoppableThreadConfiguration<T> setPausable(boolean pausable) {
        this.pausable = pausable;
        return this;
    }

    public Duration getMinimumPeriod() {
        return this.minimumPeriod;
    }

    public StoppableThreadConfiguration<T> setMinimumPeriod(Duration minimumPeriod) {
        this.minimumPeriod = minimumPeriod;
        return this;
    }

    public double getMaximumRate() {
        if (this.minimumPeriod == null) {
            return -1.0;
        }
        return 1.0 / ((double)this.minimumPeriod.toNanos() * 1.0E-9);
    }

    public StoppableThreadConfiguration<T> setMaximumRate(double hz) {
        if (hz <= 0.0) {
            throw new IllegalArgumentException("invalid hertz value " + hz);
        }
        this.minimumPeriod = Duration.ofNanos((long)(1.0 / hz * 1.0E9));
        return this;
    }

    public int getJoinWaitMs() {
        return this.joinWaitMs;
    }

    public StoppableThreadConfiguration<T> setJoinWaitMs(int joinWaitMs) {
        this.joinWaitMs = joinWaitMs;
        return this;
    }

    public ThreadGroup getThreadGroup() {
        return this.threadConfiguration.getThreadGroup();
    }

    public StoppableThreadConfiguration<T> setThreadGroup(ThreadGroup threadGroup) {
        this.threadConfiguration.setThreadGroup(threadGroup);
        return this;
    }

    public boolean isDaemon() {
        return this.threadConfiguration.isDaemon();
    }

    public StoppableThreadConfiguration<T> setDaemon(boolean daemon) {
        this.threadConfiguration.setDaemon(daemon);
        return this;
    }

    public int getPriority() {
        return this.threadConfiguration.getPriority();
    }

    public StoppableThreadConfiguration<T> setPriority(int priority) {
        this.threadConfiguration.setPriority(priority);
        return this;
    }

    public ClassLoader getContextClassLoader() {
        return this.threadConfiguration.getContextClassLoader();
    }

    public StoppableThreadConfiguration<T> setContextClassLoader(ClassLoader contextClassLoader) {
        this.threadConfiguration.setContextClassLoader(contextClassLoader);
        return this;
    }

    public Thread.UncaughtExceptionHandler getExceptionHandler() {
        return this.threadConfiguration.getExceptionHandler();
    }

    public StoppableThreadConfiguration<T> setExceptionHandler(Thread.UncaughtExceptionHandler exceptionHandler) {
        this.threadConfiguration.setExceptionHandler(exceptionHandler);
        return this;
    }

    public long getNodeId() {
        return this.threadConfiguration.getNodeId();
    }

    public StoppableThreadConfiguration<T> setNodeId(long nodeId) {
        this.threadConfiguration.setNodeId(nodeId);
        return this;
    }

    public String getComponent() {
        return this.threadConfiguration.getComponent();
    }

    public StoppableThreadConfiguration<T> setComponent(String component) {
        this.threadConfiguration.setComponent(component);
        return this;
    }

    public String getThreadName() {
        return this.threadConfiguration.getThreadName();
    }

    public StoppableThreadConfiguration<T> setThreadName(String threadName) {
        this.threadConfiguration.setThreadName(threadName);
        return this;
    }

    public long getOtherNodeId() {
        return this.threadConfiguration.getOtherNodeId();
    }

    public StoppableThreadConfiguration<T> setOtherNodeId(long otherNodeId) {
        this.threadConfiguration.setOtherNodeId(otherNodeId);
        return this;
    }

    public Duration getHangingThreadPeriod() {
        return this.hangingThreadPeriod;
    }

    public StoppableThreadConfiguration<T> setHangingThreadPeriod(Duration hangingThreadPeriod) {
        this.hangingThreadPeriod = hangingThreadPeriod;
        return this;
    }

    public ThreadConfiguration getThreadConfiguration() {
        return this.threadConfiguration;
    }
}

