/*
 * Decompiled with CFR 0.152.
 */
package com.swirlds.common.threading;

import com.swirlds.common.threading.ThreadConfigurationFactory;
import com.swirlds.logging.LogMarker;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.IntSupplier;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class ThreadConfiguration {
    private static final Logger defaultLogger = LogManager.getLogger();
    private final AtomicInteger threadNumber = new AtomicInteger(0);
    private long nodeId = -1L;
    private String component = "default";
    private String threadName = "unnamed";
    private long otherNodeId = -1L;
    private ThreadGroup threadGroup = ThreadConfiguration.defaultThreadGroup();
    private boolean daemon = true;
    private int priority = 5;
    private ClassLoader contextClassLoader = null;
    private Thread.UncaughtExceptionHandler exceptionHandler = null;
    private Runnable runnable;

    private static ThreadGroup defaultThreadGroup() {
        SecurityManager securityManager = System.getSecurityManager();
        if (System.getSecurityManager() == null) {
            return Thread.currentThread().getThreadGroup();
        }
        return securityManager.getThreadGroup();
    }

    protected static String buildNextThreadName(String component, String threadName, long nodeId, long otherNodeId, IntSupplier threadNumber) {
        StringBuilder sb = new StringBuilder();
        sb.append("<");
        if (component != null && !component.isBlank()) {
            sb.append(component);
            if (threadName != null && !threadName.isBlank()) {
                sb.append(": ");
            } else {
                sb.append(" ");
            }
        }
        if (threadName != null && !threadName.isBlank()) {
            sb.append(threadName).append(" ");
        }
        if (nodeId == -1L) {
            sb.append("?");
        } else {
            sb.append(nodeId);
        }
        sb.append(" ");
        if (otherNodeId != -1L) {
            sb.append("to ").append(otherNodeId).append(" ");
        }
        sb.append("#").append(threadNumber.getAsInt());
        sb.append(">");
        return sb.toString();
    }

    private static Thread.UncaughtExceptionHandler buildDefaultExceptionHandler() {
        return (t, e) -> defaultLogger.error(LogMarker.EXCEPTION.getMarker(), "exception on thread {}", (Object)t.getName(), (Object)e);
    }

    public Thread build() {
        return this.build(false);
    }

    public Thread build(boolean start) {
        if (this.runnable == null) {
            throw new NullPointerException("runnable must not be null");
        }
        Thread thread = new Thread(this.getThreadGroup(), this.runnable, this.buildNextThreadName());
        thread.setDaemon(this.isDaemon());
        thread.setPriority(this.getPriority());
        thread.setUncaughtExceptionHandler(this.getExceptionHandler());
        if (this.getContextClassLoader() != null) {
            thread.setContextClassLoader(this.getContextClassLoader());
        }
        if (start) {
            thread.start();
        }
        return thread;
    }

    public ThreadFactory buildFactory() {
        this.validateConfiguration();
        return new ThreadConfigurationFactory(() -> ThreadConfiguration.buildNextThreadName(this.getComponent(), this.getThreadName(), this.getNodeId(), this.getOtherNodeId(), this.threadNumber::getAndIncrement), this.getPriority(), this.getThreadGroup(), this.isDaemon(), this.getContextClassLoader(), this.getExceptionHandler());
    }

    public String buildNextThreadName() {
        this.validateConfiguration();
        return ThreadConfiguration.buildNextThreadName(this.component, this.threadName, this.nodeId, this.otherNodeId, this.threadNumber::getAndIncrement);
    }

    public ThreadGroup getThreadGroup() {
        return this.threadGroup;
    }

    public ThreadConfiguration setThreadGroup(ThreadGroup threadGroup) {
        this.threadGroup = threadGroup;
        return this;
    }

    public boolean isDaemon() {
        return this.daemon;
    }

    public ThreadConfiguration setDaemon(boolean daemon) {
        this.daemon = daemon;
        return this;
    }

    public int getPriority() {
        return this.priority;
    }

    public ThreadConfiguration setPriority(int priority) {
        this.priority = priority;
        return this;
    }

    public ClassLoader getContextClassLoader() {
        return this.contextClassLoader;
    }

    public ThreadConfiguration setContextClassLoader(ClassLoader contextClassLoader) {
        this.contextClassLoader = contextClassLoader;
        return this;
    }

    public Thread.UncaughtExceptionHandler getExceptionHandler() {
        return this.exceptionHandler == null ? ThreadConfiguration.buildDefaultExceptionHandler() : this.exceptionHandler;
    }

    public ThreadConfiguration setExceptionHandler(Thread.UncaughtExceptionHandler exceptionHandler) {
        this.exceptionHandler = exceptionHandler;
        return this;
    }

    public long getNodeId() {
        return this.nodeId;
    }

    public ThreadConfiguration setNodeId(long nodeId) {
        this.nodeId = nodeId;
        return this;
    }

    public String getComponent() {
        return this.component;
    }

    public ThreadConfiguration setComponent(String component) {
        this.component = component;
        return this;
    }

    public String getThreadName() {
        return this.threadName;
    }

    public ThreadConfiguration setThreadName(String threadName) {
        this.threadName = threadName;
        return this;
    }

    public long getOtherNodeId() {
        return this.otherNodeId;
    }

    public ThreadConfiguration setOtherNodeId(long otherNodeId) {
        this.otherNodeId = otherNodeId;
        return this;
    }

    public Runnable getRunnable() {
        return this.runnable;
    }

    public ThreadConfiguration setRunnable(Runnable runnable) {
        this.runnable = runnable;
        return this;
    }

    protected void validateConfiguration() {
        if ((this.component == null || this.component.isBlank()) && (this.threadName == null || this.threadName.isBlank())) {
            throw new IllegalArgumentException("Component and threadName may not both be null/empty, one or both must be provided.");
        }
    }
}

