/*
 * Decompiled with CFR 0.152.
 */
package com.swirlds.common.threading;

import java.util.concurrent.ThreadFactory;
import java.util.function.Supplier;

class ThreadConfigurationFactory
implements ThreadFactory {
    private final Supplier<String> threadName;
    private final int priority;
    private final ThreadGroup threadGroup;
    private final boolean daemon;
    private final ClassLoader contextClassLoader;
    private final Thread.UncaughtExceptionHandler exceptionHandler;

    ThreadConfigurationFactory(Supplier<String> threadName, int priority, ThreadGroup threadGroup, boolean daemon, ClassLoader contextClassLoader, Thread.UncaughtExceptionHandler exceptionHandler) {
        this.threadName = threadName;
        this.priority = priority;
        this.threadGroup = threadGroup;
        this.daemon = daemon;
        this.contextClassLoader = contextClassLoader;
        this.exceptionHandler = exceptionHandler;
    }

    @Override
    public Thread newThread(Runnable runnable) {
        Thread thread = new Thread(this.threadGroup, runnable);
        thread.setName(this.threadName.get());
        thread.setPriority(this.priority);
        thread.setDaemon(this.daemon);
        thread.setContextClassLoader(this.contextClassLoader);
        thread.setUncaughtExceptionHandler(this.exceptionHandler);
        return thread;
    }
}

