/*
 * Decompiled with CFR 0.152.
 */
package com.swirlds.common.transaction.internal;

import com.swirlds.common.Transaction;
import com.swirlds.common.TransactionType;
import com.swirlds.common.crypto.TransactionSignature;
import com.swirlds.common.internal.SettingsCommon;
import com.swirlds.common.io.BadIOException;
import com.swirlds.common.io.SerializableDataInputStream;
import com.swirlds.common.io.SerializableDataOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;

@Deprecated(forRemoval=true)
public class LegacyTransaction
implements Transaction {
    private static final long CLASS_ID = -6850642169651270454L;
    private static final int CLASS_VERSION = 1;
    private static final int CHECKSUM_CONSTANT_277 = 277;
    private static final int CHECKSUM_CONSTANT_353 = 353;
    private static final String CONTENT_ERROR = "content is null or length is 0";
    private byte[] contents;
    private List<TransactionSignature> signatures;
    private boolean system;

    public LegacyTransaction() {
    }

    private LegacyTransaction(byte[] contents, boolean system, TransactionSignature ... signatures) {
        this(contents, system, signatures != null && signatures.length > 0 ? Arrays.asList(signatures) : null);
    }

    private LegacyTransaction(byte[] contents, boolean system, List<TransactionSignature> signatures) {
        if (contents == null || contents.length == 0) {
            throw new IllegalArgumentException(CONTENT_ERROR);
        }
        this.contents = (byte[])contents.clone();
        this.system = system;
        if (signatures != null && !signatures.isEmpty()) {
            this.signatures = new ArrayList<TransactionSignature>(signatures);
        }
    }

    @Deprecated(forRemoval=true)
    private static LegacyTransaction deserialize(DataInputStream dis, int[] byteCount) throws IOException {
        TransactionSignature[] sigs;
        if (dis == null) {
            throw new IllegalArgumentException("dis");
        }
        int[] totalBytes = new int[]{17};
        int txLen = dis.readInt();
        int txChecksum = dis.readInt();
        if (txLen < 0 || txChecksum != 277 - txLen) {
            throw new BadIOException("Transaction.deserialize tried to create contents array of length " + txLen + " with wrong checksum.");
        }
        if (txLen > SettingsCommon.transactionMaxBytes) {
            throw new BadIOException(String.format("Transaction.deserialize tried to create contents array of length (%d) which is larger than maximum allowed size for a transaction (transactionMaxBytes = %d)", txLen, SettingsCommon.transactionMaxBytes));
        }
        boolean system = dis.readBoolean();
        byte[] contents = new byte[txLen];
        dis.readFully(contents);
        totalBytes[0] = totalBytes[0] + contents.length;
        int sigLen = dis.readInt();
        int sigChecksum = dis.readInt();
        if (sigLen < 0 || sigChecksum != 353 - sigLen) {
            throw new BadIOException("Transaction.deserialize tried to create signature array of length " + txLen + " with wrong checksum.");
        }
        TransactionSignature[] transactionSignatureArray = sigs = sigLen > 0 ? new TransactionSignature[sigLen] : null;
        if (sigs != null) {
            for (int i = 0; i < sigs.length; ++i) {
                sigs[i] = TransactionSignature.deserialize(dis, totalBytes);
            }
        }
        if (byteCount != null && byteCount.length > 0) {
            byteCount[0] = byteCount[0] + totalBytes[0];
        }
        return new LegacyTransaction(contents, system, sigs);
    }

    @Deprecated(forRemoval=true)
    private static void serialize(LegacyTransaction transaction, DataOutputStream dos, int[] byteCount, boolean withSignatures) throws IOException {
        if (transaction == null) {
            throw new IllegalArgumentException("transaction");
        }
        if (dos == null) {
            throw new IllegalArgumentException("dos");
        }
        byte[] contents = transaction.contents;
        boolean system = transaction.system;
        int[] totalBytes = new int[]{17 + contents.length * 1};
        dos.writeInt(contents.length);
        dos.writeInt(277 - contents.length);
        dos.writeBoolean(system);
        dos.write(contents);
        boolean sigLen = false;
        dos.writeInt(0);
        dos.writeInt(353);
        if (byteCount != null && byteCount.length > 0) {
            byteCount[0] = byteCount[0] + totalBytes[0];
        }
    }

    @Override
    public void serialize(SerializableDataOutputStream out) throws IOException {
        LegacyTransaction.serialize(this, out, new int[0], false);
    }

    @Override
    public void deserialize(SerializableDataInputStream in, int version) throws IOException {
        LegacyTransaction t = LegacyTransaction.deserialize(in, null);
        this.contents = t.contents;
        this.system = t.system;
        this.signatures = t.signatures;
    }

    public byte[] getContents() {
        if (this.contents == null || this.contents.length == 0) {
            throw new IllegalArgumentException(CONTENT_ERROR);
        }
        return (byte[])this.contents.clone();
    }

    public int hashCode() {
        int result = Objects.hash(this.system);
        result = 31 * result + Arrays.hashCode(this.contents);
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof LegacyTransaction)) {
            return false;
        }
        LegacyTransaction that = (LegacyTransaction)obj;
        return this.system == that.system && Arrays.equals(this.contents, that.contents);
    }

    @Override
    public long getClassId() {
        return -6850642169651270454L;
    }

    @Override
    public int getVersion() {
        return 1;
    }

    @Override
    public int getSerializedLength() {
        return 9 + (this.contents == null ? 0 : this.contents.length) + 4 + 4;
    }

    @Override
    public TransactionType getTransactionType() {
        return TransactionType.APPLICATION;
    }

    @Override
    public int getSize() {
        return this.contents == null ? 0 : this.contents.length;
    }
}

