/*
 * Decompiled with CFR 0.152.
 */
package com.swirlds.common.bloom.hasher;

import com.swirlds.common.bloom.BloomHasher;
import com.swirlds.common.crypto.CryptoFactory;
import com.swirlds.common.crypto.Hash;
import com.swirlds.common.io.SelfSerializable;
import com.swirlds.common.io.streams.SerializableDataInputStream;
import com.swirlds.common.io.streams.SerializableDataOutputStream;
import com.swirlds.common.utility.ByteUtils;
import com.swirlds.common.utility.NonCryptographicHashing;
import java.io.IOException;

public class SelfSerializableBloomHasher<T extends SelfSerializable>
implements BloomHasher<T> {
    private static final long CLASS_ID = -2919106901136005009L;

    @Override
    public void hash(T element, long maxHash, long[] hashes) {
        int index;
        Hash hash = CryptoFactory.getInstance().digestSync((SelfSerializable)element);
        byte[] hashBytes = hash.getValue();
        for (index = 0; (index + 1) * 8 <= hashBytes.length && index < hashes.length; ++index) {
            hashes[index] = ByteUtils.byteArrayToLong(hashBytes, index * 8);
        }
        int cryptographicHashCount = index;
        while (index < hashes.length) {
            hashes[index] = NonCryptographicHashing.hash64(hashes[index - cryptographicHashCount]);
            ++index;
        }
        for (index = 0; index < hashes.length; ++index) {
            hashes[index] = Math.abs(hashes[index]) % maxHash;
        }
    }

    @Override
    public long getClassId() {
        return -2919106901136005009L;
    }

    @Override
    public void serialize(SerializableDataOutputStream out) throws IOException {
    }

    @Override
    public void deserialize(SerializableDataInputStream in, int version) throws IOException {
    }

    @Override
    public int getVersion() {
        return 1;
    }

    private static final class ClassVersion {
        public static final int ORIGINAL = 1;

        private ClassVersion() {
        }
    }
}

