/*
 * Decompiled with CFR 0.152.
 */
package com.swirlds.common.crypto;

import com.swirlds.common.crypto.DigestType;
import com.swirlds.common.crypto.Hash;
import com.swirlds.common.crypto.Message;
import com.swirlds.common.crypto.SerializableHashable;
import com.swirlds.common.crypto.SignatureType;
import com.swirlds.common.crypto.TransactionSignature;
import com.swirlds.common.io.SelfSerializable;
import com.swirlds.common.merkle.MerkleInternal;
import com.swirlds.common.merkle.MerkleLeaf;
import com.swirlds.common.merkle.MerkleNode;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.Future;

public interface Cryptography {
    public static final boolean DEFAULT_SET_HASH = true;
    public static final DigestType DEFAULT_DIGEST_TYPE = DigestType.SHA_384;

    public void digestAsync(Message var1);

    public void digestAsync(List<Message> var1);

    default public Future<Hash> digestAsync(byte[] message) {
        return this.digestAsync(message, DEFAULT_DIGEST_TYPE);
    }

    public Future<Hash> digestAsync(byte[] var1, DigestType var2);

    public Hash digestSync(Message var1);

    public void digestSync(List<Message> var1);

    default public Hash digestSync(byte[] message) {
        return this.digestSync(message, DEFAULT_DIGEST_TYPE);
    }

    public Hash digestSync(byte[] var1, DigestType var2);

    default public Hash digestSync(SelfSerializable serializable) {
        return this.digestSync(serializable, DEFAULT_DIGEST_TYPE);
    }

    public Hash digestSync(SelfSerializable var1, DigestType var2);

    default public Hash digestSync(SerializableHashable serializableHashable) {
        return this.digestSync(serializableHashable, DEFAULT_DIGEST_TYPE);
    }

    default public Hash digestSync(SerializableHashable serializableHashable, DigestType digestType) {
        return this.digestSync(serializableHashable, digestType, true);
    }

    public Hash digestSync(SerializableHashable var1, DigestType var2, boolean var3);

    default public Hash digestSync(MerkleInternal node) {
        return this.digestSync(node, DEFAULT_DIGEST_TYPE);
    }

    default public Hash digestSync(MerkleInternal node, DigestType digestType) {
        return this.digestSync(node, digestType, true);
    }

    default public Hash digestSync(MerkleInternal node, DigestType digestType, boolean setHash) {
        ArrayList<Hash> childHashes = new ArrayList<Hash>(node.getNumberOfChildren());
        for (int childIndex = 0; childIndex < node.getNumberOfChildren(); ++childIndex) {
            Object child = node.getChild(childIndex);
            if (child == null) {
                childHashes.add(this.getNullHash(digestType));
                continue;
            }
            childHashes.add(child.getHash());
        }
        return this.digestSync(node, childHashes, setHash);
    }

    default public Hash digestSync(MerkleInternal node, List<Hash> childHashes) {
        return this.digestSync(node, childHashes, true);
    }

    public Hash digestSync(MerkleInternal var1, List<Hash> var2, boolean var3);

    default public Hash digestSync(MerkleLeaf leaf, DigestType digestType) {
        return this.digestSync((SerializableHashable)leaf, digestType);
    }

    default public Hash digestSync(MerkleNode node, DigestType digestType) {
        if (node.isLeaf()) {
            return this.digestSync(node.asLeaf(), digestType);
        }
        return this.digestSync(node.asInternal(), digestType);
    }

    public Hash digestTreeSync(MerkleNode var1, DigestType var2);

    default public Hash digestTreeSync(MerkleNode root) {
        return this.digestTreeSync(root, DEFAULT_DIGEST_TYPE);
    }

    public Future<Hash> digestTreeAsync(MerkleNode var1, DigestType var2);

    default public Future<Hash> digestTreeAsync(MerkleNode root) {
        return this.digestTreeAsync(root, DEFAULT_DIGEST_TYPE);
    }

    default public Hash getNullHash() {
        return this.getNullHash(DEFAULT_DIGEST_TYPE);
    }

    public Hash getNullHash(DigestType var1);

    public void verifyAsync(TransactionSignature var1);

    public void verifyAsync(List<TransactionSignature> var1);

    default public Future<Boolean> verifyAsync(byte[] data, byte[] signature, byte[] publicKey) {
        return this.verifyAsync(data, signature, publicKey, SignatureType.ED25519);
    }

    public Future<Boolean> verifyAsync(byte[] var1, byte[] var2, byte[] var3, SignatureType var4);

    public boolean verifySync(TransactionSignature var1);

    public boolean verifySync(List<TransactionSignature> var1);

    default public boolean verifySync(byte[] data, byte[] signature, byte[] publicKey) {
        return this.verifySync(data, signature, publicKey, SignatureType.ED25519);
    }

    public boolean verifySync(byte[] var1, byte[] var2, byte[] var3, SignatureType var4);

    public Hash calcRunningHash(Hash var1, Hash var2, DigestType var3);
}

