/*
 * Decompiled with CFR 0.152.
 */
package com.swirlds.common.crypto;

public enum DigestType {
    SHA_384(1493139739, "SHA-384", "SUN", 48),
    SHA_512(-1882633858, "SHA-512", "SUN", 64);

    private static final int MAX_LENGTH = 64;
    private final int id;
    private final String algorithmName;
    private final String provider;
    private final int outputLength;

    private DigestType(int id, String algorithmName, String provider, int outputLength) {
        this.id = id;
        this.algorithmName = algorithmName;
        this.provider = provider;
        this.outputLength = outputLength;
    }

    public static DigestType valueOf(int id) {
        switch (id) {
            case 1493139739: {
                return SHA_384;
            }
            case -1882633858: {
                return SHA_512;
            }
        }
        return null;
    }

    public int id() {
        return this.id;
    }

    public String algorithmName() {
        return this.algorithmName;
    }

    public String provider() {
        return this.provider;
    }

    public int digestLength() {
        return this.outputLength;
    }

    public static int getMaxLength() {
        return 64;
    }
}

