/*
 * Decompiled with CFR 0.152.
 */
package com.swirlds.common.crypto;

import com.swirlds.common.crypto.SignatureType;
import com.swirlds.common.io.SelfSerializable;
import com.swirlds.common.io.streams.SerializableDataInputStream;
import com.swirlds.common.io.streams.SerializableDataOutputStream;
import com.swirlds.common.utility.CommonUtils;
import com.swirlds.logging.LogMarker;
import java.io.IOException;
import java.security.InvalidKeyException;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.security.PublicKey;
import java.security.SignatureException;
import java.util.Arrays;
import java.util.Objects;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class Signature
implements SelfSerializable {
    private static final Logger log = LogManager.getLogger();
    private static final long CLASS_ID = 1431101492385045609L;
    private static final int CLASS_VERSION = 1;
    private SignatureType signatureType;
    private byte[] sigBytes;

    public Signature() {
    }

    public Signature(SignatureType signatureType, byte[] sigBytes) {
        this.signatureType = signatureType;
        this.sigBytes = sigBytes;
    }

    @Override
    public void deserialize(SerializableDataInputStream in, int version) throws IOException {
        this.signatureType = SignatureType.from(in.readInt(), SignatureType.RSA);
        this.sigBytes = in.readByteArray(this.signatureType.signatureLength(), true);
    }

    @Override
    public void serialize(SerializableDataOutputStream out) throws IOException {
        out.writeInt(this.signatureType.ordinal());
        out.writeByteArray(this.sigBytes, true);
    }

    public boolean verifySignature(byte[] data, PublicKey publicKey) {
        if (publicKey == null) {
            log.info(LogMarker.EXCEPTION.getMarker(), "verifySignature :: missing PublicKey");
            return false;
        }
        String signingAlgorithm = this.signatureType.signingAlgorithm();
        String sigProvider = this.signatureType.provider();
        try {
            java.security.Signature sig = java.security.Signature.getInstance(signingAlgorithm, sigProvider);
            sig.initVerify(publicKey);
            sig.update(data);
            return sig.verify(this.sigBytes);
        }
        catch (InvalidKeyException | NoSuchAlgorithmException | NoSuchProviderException | SignatureException e) {
            log.error(LogMarker.EXCEPTION.getMarker(), " verifySignature :: Fail to verify Signature: {}, PublicKey: {}", (Object)this, (Object)CommonUtils.hex(publicKey.getEncoded()), (Object)e);
            return false;
        }
    }

    @Override
    public long getClassId() {
        return 1431101492385045609L;
    }

    @Override
    public int getVersion() {
        return 1;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof Signature)) {
            return false;
        }
        Signature signature = (Signature)obj;
        return Arrays.equals(this.sigBytes, signature.sigBytes) && this.signatureType == signature.signatureType;
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.signatureType, Arrays.hashCode(this.sigBytes)});
    }

    public String toString() {
        return String.format("Signature{signatureType: %s, sigBytes: %s", new Object[]{this.signatureType, CommonUtils.hex(this.sigBytes)});
    }
}

