/*
 * Decompiled with CFR 0.152.
 */
package com.swirlds.common.crypto.engine;

import com.swirlds.common.crypto.CryptographyException;
import com.swirlds.common.crypto.SignatureType;
import com.swirlds.common.utility.CommonUtils;
import com.swirlds.logging.LogMarker;
import java.math.BigInteger;
import java.security.AlgorithmParameters;
import java.security.InvalidKeyException;
import java.security.KeyFactory;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.security.Signature;
import java.security.SignatureException;
import java.security.interfaces.ECPublicKey;
import java.security.spec.ECGenParameterSpec;
import java.security.spec.ECParameterSpec;
import java.security.spec.ECPoint;
import java.security.spec.ECPublicKeySpec;
import java.security.spec.InvalidKeySpecException;
import java.security.spec.InvalidParameterSpecException;
import java.util.Arrays;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class EcdsaSecp256k1Verifier {
    public static final int EC_COORD_SIZE = 32;
    private static final Logger LOGGER = LogManager.getLogger(EcdsaSecp256k1Verifier.class);
    private static final byte SIGN_MASK = -128;
    private static final byte ASN1_INTEGER_TAG = 2;
    private static final byte ASN1_SEQUENCE_TAG = 48;
    private static final byte[] ZERO = new byte[]{0};
    private static final int TWO = 2;
    private static final int THREE = 3;
    private static final int FOUR = 4;
    private static final int FIVE = 5;
    private static final int SIX = 6;
    private final KeyFactory ecKeyFactory;
    private final ECParameterSpec secp256k1Params;
    private final Signature algorithm;

    public EcdsaSecp256k1Verifier() {
        try {
            this.ecKeyFactory = KeyFactory.getInstance(SignatureType.ECDSA_SECP256K1.keyAlgorithm());
            AlgorithmParameters params = AlgorithmParameters.getInstance(SignatureType.ECDSA_SECP256K1.keyAlgorithm());
            params.init(new ECGenParameterSpec(SignatureType.ECDSA_SECP256K1.ellipticalCurve()));
            this.secp256k1Params = params.getParameterSpec(ECParameterSpec.class);
            this.algorithm = Signature.getInstance(SignatureType.ECDSA_SECP256K1.signingAlgorithm(), SignatureType.ECDSA_SECP256K1.provider());
        }
        catch (NoSuchAlgorithmException | NoSuchProviderException | InvalidParameterSpecException fatal) {
            throw new CryptographyException(fatal, LogMarker.ERROR);
        }
    }

    public static byte[] asn1DerEncode(byte[] rawEcdsaSig) {
        byte[] r = EcdsaSecp256k1Verifier.minifiedPositiveBigEndian(Arrays.copyOfRange(rawEcdsaSig, 0, 32));
        byte[] s = EcdsaSecp256k1Verifier.minifiedPositiveBigEndian(Arrays.copyOfRange(rawEcdsaSig, 32, rawEcdsaSig.length));
        int len = r.length + s.length + 6;
        byte[] derSig = new byte[len];
        derSig[0] = 48;
        derSig[1] = (byte)(len - 2);
        derSig[2] = 2;
        derSig[3] = (byte)r.length;
        System.arraycopy(r, 0, derSig, 4, r.length);
        derSig[4 + r.length] = 2;
        derSig[5 + r.length] = (byte)s.length;
        System.arraycopy(s, 0, derSig, 6 + r.length, s.length);
        return derSig;
    }

    public static byte[] minifiedPositiveBigEndian(byte[] v) {
        byte[] result;
        int firstNonZero;
        for (firstNonZero = 0; firstNonZero < v.length && v[firstNonZero] == 0; ++firstNonZero) {
        }
        if (firstNonZero == v.length) {
            return ZERO;
        }
        if ((v[firstNonZero] & 0xFFFFFF80) == 0) {
            result = firstNonZero == 0 ? v : Arrays.copyOfRange(v, firstNonZero, v.length);
        } else {
            byte[] minified = new byte[1 + v.length - firstNonZero];
            System.arraycopy(v, firstNonZero, minified, 1, v.length - firstNonZero);
            result = minified;
        }
        return result;
    }

    public boolean verify(byte[] rawSig, byte[] msg, byte[] pubKey) {
        try {
            this.algorithm.initVerify(this.asCryptographic(pubKey));
            this.algorithm.update(msg);
            byte[] asn1DerSig = EcdsaSecp256k1Verifier.asn1DerEncode(rawSig);
            return this.algorithm.verify(asn1DerSig);
        }
        catch (InvalidKeyException | SignatureException | InvalidKeySpecException e) {
            LOGGER.debug(LogMarker.TESTING_EXCEPTIONS.getMarker(), "Failure while verifying signature [ publicKey = {}, rawSig = {} ]", (Object)CommonUtils.hex(pubKey), (Object)CommonUtils.hex(rawSig), (Object)e);
            return false;
        }
    }

    private ECPublicKey asCryptographic(byte[] pubKey) throws InvalidKeySpecException {
        BigInteger xCoord = new BigInteger(1, Arrays.copyOfRange(pubKey, 0, 32));
        BigInteger yCoord = new BigInteger(1, Arrays.copyOfRange(pubKey, 32, pubKey.length));
        ECPoint curvePoint = new ECPoint(xCoord, yCoord);
        ECPublicKeySpec ecPublicKeySpec = new ECPublicKeySpec(curvePoint, this.secp256k1Params);
        return (ECPublicKey)this.ecKeyFactory.generatePublic(ecPublicKeySpec);
    }
}

