/*
 * Decompiled with CFR 0.152.
 */
package com.swirlds.common.io.streams;

import com.swirlds.common.io.exceptions.BadIOException;
import com.swirlds.common.utility.CommonUtils;
import java.io.DataInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.time.Instant;
import java.util.ArrayList;
import java.util.List;

public class AugmentedDataInputStream
extends InputStream {
    private final DataInputStream baseStream;

    public AugmentedDataInputStream(InputStream in) {
        this.baseStream = new DataInputStream(in);
    }

    @Override
    public int available() throws IOException {
        return this.baseStream.available();
    }

    @Override
    public void close() throws IOException {
        this.baseStream.close();
    }

    @Override
    public int read() throws IOException {
        return this.baseStream.read();
    }

    @Override
    public int read(byte[] b, int off, int len) throws IOException {
        return this.baseStream.read(b, off, len);
    }

    @Override
    public long skip(long n) throws IOException {
        return this.baseStream.skip(n);
    }

    @Override
    public byte[] readAllBytes() throws IOException {
        return this.baseStream.readAllBytes();
    }

    @Override
    public byte[] readNBytes(int len) throws IOException {
        return this.baseStream.readNBytes(len);
    }

    @Override
    public int readNBytes(byte[] b, int off, int len) throws IOException {
        return this.baseStream.readNBytes(b, off, len);
    }

    @Override
    public void skipNBytes(long n) throws IOException {
        this.baseStream.skipNBytes(n);
    }

    public void readFully(byte[] b) throws IOException {
        this.baseStream.readFully(b);
    }

    public void readFully(byte[] b, int off, int len) throws IOException {
        this.baseStream.readFully(b, off, len);
    }

    public int skipBytes(int n) throws IOException {
        return this.baseStream.skipBytes(n);
    }

    public boolean readBoolean() throws IOException {
        return this.baseStream.readBoolean();
    }

    public byte readByte() throws IOException {
        return this.baseStream.readByte();
    }

    public int readUnsignedByte() throws IOException {
        return this.baseStream.readUnsignedByte();
    }

    public short readShort() throws IOException {
        return this.baseStream.readShort();
    }

    public int readUnsignedShort() throws IOException {
        return this.baseStream.readUnsignedShort();
    }

    public char readChar() throws IOException {
        return this.baseStream.readChar();
    }

    public int readInt() throws IOException {
        return this.baseStream.readInt();
    }

    public long readLong() throws IOException {
        return this.baseStream.readLong();
    }

    public float readFloat() throws IOException {
        return this.baseStream.readFloat();
    }

    public double readDouble() throws IOException {
        return this.baseStream.readDouble();
    }

    public String readUTF() throws IOException {
        return this.baseStream.readUTF();
    }

    public byte[] readByteArray(int maxLength, boolean readChecksum) throws IOException {
        int checksum;
        int len = this.readInt();
        if (len < 0) {
            return null;
        }
        if (readChecksum && (checksum = this.readInt()) != 101 - len) {
            throw new BadIOException("SerializableDataInputStream tried to create array of length " + len + " with wrong checksum.");
        }
        this.checkLengthLimit(len, maxLength);
        byte[] bytes = new byte[len];
        this.readFully(bytes);
        return bytes;
    }

    public byte[] readByteArray(int maxLength) throws IOException {
        return this.readByteArray(maxLength, false);
    }

    public int[] readIntArray(int maxLength) throws IOException {
        int len = this.readInt();
        if (len == -1) {
            return null;
        }
        this.checkLengthLimit(len, maxLength);
        int[] data = new int[len];
        for (int i = 0; i < len; ++i) {
            data[i] = this.readInt();
        }
        return data;
    }

    public List<Integer> readIntList(int maxLength) throws IOException {
        int len = this.readInt();
        if (len == -1) {
            return null;
        }
        this.checkLengthLimit(len, maxLength);
        ArrayList<Integer> data = new ArrayList<Integer>(len);
        for (int i = 0; i < len; ++i) {
            data.add(this.readInt());
        }
        return data;
    }

    public long[] readLongArray(int maxLength) throws IOException {
        int len = this.readInt();
        if (len == -1) {
            return null;
        }
        this.checkLengthLimit(len, maxLength);
        long[] data = new long[len];
        for (int i = 0; i < len; ++i) {
            data[i] = this.readLong();
        }
        return data;
    }

    public List<Long> readLongList(int maxLength) throws IOException {
        int len = this.readInt();
        if (len == -1) {
            return null;
        }
        this.checkLengthLimit(len, maxLength);
        ArrayList<Long> data = new ArrayList<Long>(len);
        for (int i = 0; i < len; ++i) {
            data.add(this.readLong());
        }
        return data;
    }

    public List<Boolean> readBooleanList(int maxLength) throws IOException {
        int len = this.readInt();
        if (len == -1) {
            return null;
        }
        this.checkLengthLimit(len, maxLength);
        ArrayList<Boolean> data = new ArrayList<Boolean>(len);
        for (int i = 0; i < len; ++i) {
            data.add(this.readBoolean());
        }
        return data;
    }

    public float[] readFloatArray(int maxLength) throws IOException {
        int len = this.readInt();
        if (len == -1) {
            return null;
        }
        this.checkLengthLimit(len, maxLength);
        float[] data = new float[len];
        for (int i = 0; i < len; ++i) {
            data[i] = this.readFloat();
        }
        return data;
    }

    public List<Float> readFloatList(int maxLength) throws IOException {
        int len = this.readInt();
        if (len == -1) {
            return null;
        }
        this.checkLengthLimit(len, maxLength);
        ArrayList<Float> data = new ArrayList<Float>(len);
        for (int i = 0; i < len; ++i) {
            data.add(Float.valueOf(this.readFloat()));
        }
        return data;
    }

    public double[] readDoubleArray(int maxLength) throws IOException {
        int len = this.readInt();
        if (len == -1) {
            return null;
        }
        this.checkLengthLimit(len, maxLength);
        double[] data = new double[len];
        for (int i = 0; i < len; ++i) {
            data[i] = this.readDouble();
        }
        return data;
    }

    public List<Double> readDoubleList(int maxLength) throws IOException {
        int len = this.readInt();
        if (len == -1) {
            return null;
        }
        this.checkLengthLimit(len, maxLength);
        ArrayList<Double> data = new ArrayList<Double>(len);
        for (int i = 0; i < len; ++i) {
            data.add(this.readDouble());
        }
        return data;
    }

    public String[] readStringArray(int maxLength, int maxStringLength) throws IOException {
        int len = this.readInt();
        if (len == -1) {
            return null;
        }
        this.checkLengthLimit(len, maxLength);
        String[] data = new String[len];
        for (int i = 0; i < len; ++i) {
            data[i] = this.readNormalisedString(maxStringLength);
        }
        return data;
    }

    public List<String> readStringList(int maxLength, int maxStringLength) throws IOException {
        int len = this.readInt();
        if (len == -1) {
            return null;
        }
        this.checkLengthLimit(len, maxLength);
        ArrayList<String> data = new ArrayList<String>(len);
        for (int i = 0; i < len; ++i) {
            data.add(this.readNormalisedString(maxStringLength));
        }
        return data;
    }

    public Instant readInstant() throws IOException {
        long epochSecond = this.readLong();
        if (epochSecond == Long.MIN_VALUE) {
            return null;
        }
        long nanos = this.readLong();
        if (nanos < 0L || nanos > 999999999L) {
            throw new IOException("Instant.nanosecond is not within the allowed range!");
        }
        return Instant.ofEpochSecond(epochSecond, nanos);
    }

    public String readNormalisedString(int maxLength) throws IOException {
        byte[] data = this.readByteArray(maxLength);
        if (data == null) {
            return null;
        }
        return CommonUtils.getNormalisedStringFromBytes(data);
    }

    protected void checkLengthLimit(int length, int maxLength) throws IOException {
        if (length > maxLength) {
            throw new IOException(String.format("The input stream provided a length of %d for the list/array which exceeds the maxLength of %d", length, maxLength));
        }
    }
}

