/*
 * Decompiled with CFR 0.152.
 */
package com.swirlds.common.merkle.iterators.internal;

import com.swirlds.common.merkle.MerkleInternal;
import com.swirlds.common.merkle.MerkleNode;
import com.swirlds.common.merkle.iterators.internal.MerkleIterationAlgorithm;
import java.util.Deque;
import java.util.LinkedList;
import java.util.function.ObjIntConsumer;

public class PostOrderedDepthFirstAlgorithm
implements MerkleIterationAlgorithm {
    private final Deque<MerkleNode> stack = new LinkedList<MerkleNode>();

    @Override
    public void push(MerkleNode node) {
        this.stack.push(node);
    }

    @Override
    public MerkleNode pop() {
        return this.stack.pop();
    }

    @Override
    public MerkleNode peek() {
        return this.stack.peek();
    }

    @Override
    public int size() {
        return this.stack.size();
    }

    @Override
    public void pushChildren(MerkleInternal parent, ObjIntConsumer<MerkleInternal> pushNode) {
        for (int childIndex = parent.getNumberOfChildren() - 1; childIndex >= 0; --childIndex) {
            pushNode.accept(parent, childIndex);
        }
    }
}

