/*
 * Decompiled with CFR 0.152.
 */
package com.swirlds.common.merkle.synchronization.internal;

import com.swirlds.common.merkle.synchronization.internal.QueryResponse;
import com.swirlds.common.merkle.synchronization.streams.AsyncInputStream;
import com.swirlds.common.merkle.synchronization.utility.MerkleSynchronizationException;
import com.swirlds.common.merkle.synchronization.views.TeacherTreeView;
import com.swirlds.common.threading.pool.StandardWorkGroup;
import com.swirlds.logging.LogMarker;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class TeacherReceivingThread<T> {
    private static final Logger LOG = LogManager.getLogger(TeacherReceivingThread.class);
    private static final String NAME = "receiver";
    private final StandardWorkGroup workGroup;
    private final AsyncInputStream<QueryResponse> in;
    private final TeacherTreeView<T> view;
    private final AtomicBoolean senderIsFinished;

    public TeacherReceivingThread(StandardWorkGroup workGroup, AsyncInputStream<QueryResponse> in, TeacherTreeView<T> view, AtomicBoolean senderIsFinished) {
        this.workGroup = workGroup;
        this.in = in;
        this.view = view;
        this.senderIsFinished = senderIsFinished;
    }

    public void start() {
        this.workGroup.execute(NAME, this::run);
    }

    private void run() {
        try (AsyncInputStream<QueryResponse> asyncInputStream = this.in;){
            boolean finished = this.senderIsFinished.get();
            boolean responseExpected = this.view.isResponseExpected();
            while (!finished || responseExpected) {
                if (responseExpected) {
                    QueryResponse response = this.in.readAnticipatedMessage();
                    Object node = this.view.getNodeForNextResponse();
                    this.view.registerResponseForNode(node, response.doesLearnerHaveTheNode());
                } else {
                    TimeUnit.MILLISECONDS.sleep(1L);
                }
                finished = this.senderIsFinished.get();
                responseExpected = this.view.isResponseExpected();
            }
        }
        catch (InterruptedException ex) {
            LOG.warn(LogMarker.RECONNECT.getMarker(), "teacher's receiving thread interrupted");
            Thread.currentThread().interrupt();
        }
        catch (Exception ex) {
            throw new MerkleSynchronizationException("exception in the teacher's receiving thread", ex);
        }
    }
}

