/*
 * Decompiled with CFR 0.152.
 */
package com.swirlds.common.system;

import com.swirlds.common.exceptions.InvalidNodeIdException;
import com.swirlds.common.io.streams.SerializableDataInputStream;
import com.swirlds.common.io.streams.SerializableDataOutputStream;
import com.swirlds.common.merkle.utility.AbstractMerkleLeaf;
import com.swirlds.common.system.Address;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Objects;

public class AddressBook
extends AbstractMerkleLeaf
implements Iterable<Address> {
    public static final long CLASS_ID = 5685030982988856288L;
    private static final int MAX_ADDRESSES = 1000;
    private List<Address> addresses;
    private Map<String, Long> publicKeyToId;
    private long totalStake = 0L;
    private long[] stakes = null;

    public AddressBook immutableCopy() {
        AddressBook ab = new AddressBook();
        ab.addresses = Collections.unmodifiableList(new LinkedList<Address>(this.addresses));
        ab.publicKeyToId = Collections.unmodifiableMap(new HashMap<String, Long>(this.publicKeyToId));
        ab.setImmutable(true);
        ab.setHash(this.getHash());
        return ab;
    }

    public AddressBook() {
        this(new ArrayList<Address>());
    }

    private AddressBook(AddressBook that) {
        super(that);
        this.addresses = Collections.synchronizedList(new ArrayList<Address>(that.addresses));
        this.addressesToHashMap();
    }

    public AddressBook(List<Address> addresses) {
        this.addresses = Collections.synchronizedList(new ArrayList<Address>(addresses));
        this.addressesToHashMap();
    }

    @Override
    public int getVersion() {
        return 3;
    }

    @Override
    public long getClassId() {
        return 5685030982988856288L;
    }

    private void addressesToHashMap() {
        this.publicKeyToId = Collections.synchronizedMap(new HashMap());
        for (int i = 0; i < this.addresses.size(); ++i) {
            this.publicKeyToId.put(this.addresses.get(i).getNickname(), Long.valueOf(i));
        }
    }

    public int getSize() {
        return this.addresses.size();
    }

    public int getNumberWithStake() {
        return (int)this.addresses.stream().filter(v -> v.getStake() > 0L).count();
    }

    public long getTotalStake() {
        if (this.totalStake == 0L && this.addresses != null) {
            long tmpTotalStake = 0L;
            for (Address addr : this.addresses) {
                tmpTotalStake += addr.getStake();
            }
            this.totalStake = tmpTotalStake;
        }
        return this.totalStake;
    }

    public long[] getStakes() {
        if (this.stakes == null && this.addresses != null) {
            long[] tmpStakes = new long[this.addresses.size()];
            for (int id = 0; id < this.addresses.size(); ++id) {
                tmpStakes[id] = this.getStake(id);
            }
            this.stakes = tmpStakes;
        }
        return this.stakes;
    }

    public int getOwnHostCount() {
        int count = 0;
        for (int i = 0; i < this.addresses.size(); ++i) {
            if (!this.addresses.get(i).isOwnHost()) continue;
            ++count;
        }
        return count;
    }

    public long getId(String publicKey) {
        if (this.publicKeyToId == null) {
            return -1L;
        }
        Long ans = this.publicKeyToId.get(publicKey);
        if (ans == null) {
            return -1L;
        }
        return ans;
    }

    public Address getAddress(long id) {
        if (id < 0L || id >= (long)this.addresses.size()) {
            return null;
        }
        return this.addresses.get((int)id);
    }

    public long getStake(long id) {
        Address addr = this.getAddress((int)id);
        return addr == null ? 0L : addr.getStake();
    }

    public boolean isZeroStakeNode(long nodeId) {
        Address nodeAddress = this.getAddress(nodeId);
        if (nodeAddress == null) {
            throw new InvalidNodeIdException("NodeId may not be null");
        }
        return nodeAddress.getStake() == 0L;
    }

    public void setAddress(long id, Address address) {
        this.publicKeyToId.put(address.getNickname(), id);
        this.addresses.set((int)id, address);
        this.invalidateHash();
    }

    @Override
    public AddressBook copy() {
        AddressBook ab = new AddressBook(this);
        ab.setImmutable(false);
        return ab;
    }

    @Override
    public void serialize(SerializableDataOutputStream out) throws IOException {
        out.writeSerializableList(this.addresses, false, true);
    }

    @Override
    public void deserialize(SerializableDataInputStream in, int version) throws IOException {
        if (version == 0) {
            version = in.readInt();
        }
        switch (version) {
            case 1: 
            case 2: {
                this.addresses = Collections.synchronizedList(new ArrayList());
                int size = in.readInt();
                for (int i = 0; i < size; ++i) {
                    Address a = new Address();
                    a.deserialize(in, version);
                    this.addresses.add(a);
                }
                break;
            }
            default: {
                this.addresses = Collections.synchronizedList(in.readSerializableList(1000, false, Address::new));
            }
        }
        this.addressesToHashMap();
        this.totalStake = 0L;
        this.stakes = null;
    }

    @Override
    public int getMinimumSupportedVersion() {
        return 2;
    }

    @Override
    public Iterator<Address> iterator() {
        return this.addresses.iterator();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        AddressBook that = (AddressBook)o;
        return Objects.equals(this.addresses, that.addresses);
    }

    public String toString() {
        return "AddressBook{addresses=" + this.addresses + "}";
    }

    private static class ClassVersion {
        public static final int ORIGINAL = 0;
        public static final int UNDOCUMENTED = 1;
        public static final int AD_HOC_SERIALIZATION = 2;
        public static final int UTILITY_SERIALIZATION = 3;

        private ClassVersion() {
        }
    }
}

