/*
 * Decompiled with CFR 0.152.
 */
package com.swirlds.common.system.events;

import com.swirlds.common.crypto.AbstractSerializableHashable;
import com.swirlds.common.crypto.Hash;
import com.swirlds.common.internal.SettingsCommon;
import com.swirlds.common.io.OptionalSelfSerializable;
import com.swirlds.common.io.SerializableWithKnownLength;
import com.swirlds.common.io.streams.SerializableDataInputStream;
import com.swirlds.common.io.streams.SerializableDataOutputStream;
import com.swirlds.common.system.events.EventSerializationOptions;
import com.swirlds.common.system.transaction.Transaction;
import com.swirlds.common.system.transaction.internal.LegacyTransaction;
import com.swirlds.common.utility.CommonUtils;
import java.io.IOException;
import java.io.Serializable;
import java.time.Instant;
import org.apache.commons.lang3.builder.EqualsBuilder;
import org.apache.commons.lang3.builder.HashCodeBuilder;

public class BaseEventHashedData
extends AbstractSerializableHashable
implements OptionalSelfSerializable<EventSerializationOptions> {
    public static final int TO_STRING_BYTE_ARRAY_LENGTH = 5;
    private static final long CLASS_ID = 2432614563609977411L;
    private long creatorId;
    private long selfParentGen;
    private long otherParentGen;
    private Hash selfParentHash;
    private Hash otherParentHash;
    private Instant timeCreated;
    private Transaction[] transactions;
    private boolean hasUserTransactions;

    public BaseEventHashedData() {
    }

    public BaseEventHashedData(long creatorId, long selfParentGen, long otherParentGen, Hash selfParentHash, Hash otherParentHash, Instant timeCreated, Transaction[] transactions) {
        this.creatorId = creatorId;
        this.selfParentGen = selfParentGen;
        this.otherParentGen = otherParentGen;
        this.selfParentHash = selfParentHash;
        this.otherParentHash = otherParentHash;
        this.timeCreated = timeCreated;
        this.transactions = transactions;
        this.checkUserTransactions();
    }

    public BaseEventHashedData(long creatorId, long selfParentGen, long otherParentGen, byte[] selfParentHash, byte[] otherParentHash, Instant timeCreated, Transaction[] transactions) {
        this(creatorId, selfParentGen, otherParentGen, selfParentHash == null ? null : new Hash(selfParentHash), otherParentHash == null ? null : new Hash(otherParentHash), timeCreated, transactions);
    }

    @Override
    public void serialize(SerializableDataOutputStream out, EventSerializationOptions option) throws IOException {
        out.writeLong(this.creatorId);
        out.writeLong(this.selfParentGen);
        out.writeLong(this.otherParentGen);
        out.writeSerializable(this.selfParentHash, false);
        out.writeSerializable(this.otherParentHash, false);
        out.writeInstant(this.timeCreated);
        if (option == EventSerializationOptions.OMIT_TRANSACTIONS) {
            out.writeInt(SerializableDataOutputStream.getSerializedLength(null, (boolean)true, (boolean)false));
            out.writeSerializableArray(null, true, false);
        } else {
            out.writeInt(SerializableDataOutputStream.getSerializedLength((SerializableWithKnownLength[])this.transactions, (boolean)true, (boolean)false));
            out.writeSerializableArray(this.transactions, true, false);
        }
    }

    @Override
    public void serialize(SerializableDataOutputStream out) throws IOException {
        this.serialize(out, EventSerializationOptions.FULL);
    }

    @Override
    public void deserialize(SerializableDataInputStream in, int version) throws IOException {
        this.deserialize(in, version, SettingsCommon.maxTransactionCountPerEvent);
    }

    public void deserialize(SerializableDataInputStream in, int version, int maxTransactionCount) throws IOException {
        this.creatorId = in.readLong();
        this.selfParentGen = in.readLong();
        this.otherParentGen = in.readLong();
        this.selfParentHash = in.readSerializable(false, Hash::new);
        this.otherParentHash = in.readSerializable(false, Hash::new);
        this.timeCreated = in.readInstant();
        if (version == 2) {
            in.readInt();
            this.transactions = (Transaction[])in.readSerializableArray(Transaction[]::new, maxTransactionCount, true);
        } else if (version == 1) {
            this.transactions = (Transaction[])in.readSerializableArray(LegacyTransaction[]::new, maxTransactionCount, false, LegacyTransaction::new);
        } else {
            throw new UnsupportedOperationException("Unsupported version " + version);
        }
        this.checkUserTransactions();
    }

    private void checkUserTransactions() {
        if (this.transactions != null) {
            for (Transaction t : this.getTransactions()) {
                if (t.isSystem()) continue;
                this.hasUserTransactions = true;
                break;
            }
        }
    }

    public boolean hasUserTransactions() {
        return this.hasUserTransactions;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        BaseEventHashedData that = (BaseEventHashedData)o;
        return new EqualsBuilder().append(this.creatorId, that.creatorId).append(this.selfParentGen, that.selfParentGen).append(this.otherParentGen, that.otherParentGen).append((Object)this.selfParentHash, (Object)that.selfParentHash).append((Object)this.otherParentHash, (Object)that.otherParentHash).append((Object)this.timeCreated, (Object)that.timeCreated).append((Object[])this.transactions, (Object[])that.transactions).isEquals();
    }

    public int hashCode() {
        return new HashCodeBuilder(17, 37).append(this.creatorId).append(this.selfParentGen).append(this.otherParentGen).append((Object)this.selfParentHash).append((Object)this.otherParentHash).append((Object)this.timeCreated).append((Object[])this.transactions).toHashCode();
    }

    public String toString() {
        return "BaseEventHashedData{creatorId=" + this.creatorId + ", selfParentGen=" + this.selfParentGen + ", otherParentGen=" + this.otherParentGen + ", selfParentHash=" + CommonUtils.hex(this.valueOrNull(this.selfParentHash), 5) + ", otherParentHash=" + CommonUtils.hex(this.valueOrNull(this.otherParentHash), 5) + ", timeCreated=" + this.timeCreated + ", transactions size=" + (Serializable)(this.transactions == null ? "null" : Integer.valueOf(this.transactions.length)) + ", hash=" + CommonUtils.hex(this.valueOrNull(this.getHash()), 5) + "}";
    }

    private byte[] valueOrNull(Hash hash) {
        return hash == null ? null : hash.getValue();
    }

    @Override
    public long getClassId() {
        return 2432614563609977411L;
    }

    @Override
    public int getVersion() {
        return 2;
    }

    public long getCreatorId() {
        return this.creatorId;
    }

    public long getSelfParentGen() {
        return this.selfParentGen;
    }

    public long getOtherParentGen() {
        return this.otherParentGen;
    }

    public Hash getSelfParentHash() {
        return this.selfParentHash;
    }

    public Hash getOtherParentHash() {
        return this.otherParentHash;
    }

    public boolean hasSelfParent() {
        return this.selfParentHash != null;
    }

    public boolean hasOtherParent() {
        return this.otherParentHash != null;
    }

    public byte[] getSelfParentHashValue() {
        return this.selfParentHash == null ? null : this.selfParentHash.getValue();
    }

    public byte[] getOtherParentHashValue() {
        return this.otherParentHash == null ? null : this.otherParentHash.getValue();
    }

    public Instant getTimeCreated() {
        return this.timeCreated;
    }

    public Transaction[] getTransactions() {
        return this.transactions;
    }

    public long getGeneration() {
        return BaseEventHashedData.calculateGeneration(this.selfParentGen, this.otherParentGen);
    }

    public static long calculateGeneration(long selfParentGeneration, long otherParentGeneration) {
        return 1L + Math.max(selfParentGeneration, otherParentGeneration);
    }

    private static class ClassVersion {
        public static final int ORIGINAL = 1;
        public static final int TRANSACTION_SUBCLASSES = 2;

        private ClassVersion() {
        }
    }
}

