/*
 * Decompiled with CFR 0.152.
 */
package com.swirlds.common.system.transaction.internal;

import com.swirlds.common.io.streams.AugmentedDataOutputStream;
import com.swirlds.common.io.streams.SerializableDataInputStream;
import com.swirlds.common.io.streams.SerializableDataOutputStream;
import com.swirlds.common.system.transaction.Transaction;
import com.swirlds.common.system.transaction.TransactionType;
import java.io.IOException;
import java.util.Arrays;
import java.util.Objects;

public class StateSignatureTransaction
implements Transaction {
    private static final long SIG_CLASS_ID = -5805099485452653580L;
    private static final int SIG_CLASS_VERSION = 1;
    public static final int MAX_SIGNATURE_BYTES = 1024;
    private boolean isFreeze;
    private byte[] stateSignature;
    private long lastRoundReceived = 0L;

    public StateSignatureTransaction() {
    }

    public StateSignatureTransaction(boolean isFreeze, long lastRoundReceived, byte[] stateSignature) {
        this.isFreeze = isFreeze;
        this.stateSignature = stateSignature;
        this.lastRoundReceived = lastRoundReceived;
    }

    public boolean isFreeze() {
        return this.isFreeze;
    }

    public long getLastRoundReceived() {
        return this.lastRoundReceived;
    }

    public byte[] getStateSignature() {
        return this.stateSignature;
    }

    @Override
    public int getSize() {
        return this.getSerializedLength();
    }

    @Override
    public TransactionType getTransactionType() {
        return this.isFreeze ? TransactionType.SYS_TRANS_STATE_SIG_FREEZE : TransactionType.SYS_TRANS_STATE_SIG;
    }

    @Override
    public void serialize(SerializableDataOutputStream dos) throws IOException {
        dos.writeBoolean(this.isFreeze);
        dos.writeByteArray(this.stateSignature);
        dos.writeLong(this.lastRoundReceived);
    }

    @Override
    public void deserialize(SerializableDataInputStream in, int version) throws IOException {
        this.isFreeze = in.readBoolean();
        this.stateSignature = in.readByteArray(1024);
        this.lastRoundReceived = in.readLong();
    }

    @Override
    public int getMinimumSupportedVersion() {
        return 1;
    }

    @Override
    public long getClassId() {
        return -5805099485452653580L;
    }

    @Override
    public int getVersion() {
        return 1;
    }

    @Override
    public int getSerializedLength() {
        return 1 + AugmentedDataOutputStream.getArraySerializedLength(this.stateSignature) + 8;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        StateSignatureTransaction that = (StateSignatureTransaction)o;
        if (this.isFreeze != that.isFreeze) {
            return false;
        }
        return Arrays.equals(this.stateSignature, that.stateSignature);
    }

    public int hashCode() {
        return Objects.hash(this.isFreeze, this.stateSignature);
    }
}

