/*
 * Decompiled with CFR 0.152.
 */
package com.swirlds.common.threading;

import com.swirlds.common.threading.framework.StoppableThread;
import com.swirlds.logging.LogMarker;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public final class ThreadUtils {
    private static final Logger LOG = LogManager.getLogger();

    private ThreadUtils() {
    }

    public static void stopThreads(StoppableThread ... threadsToStop) throws InterruptedException {
        LOG.info(LogMarker.THREADS.getMarker(), "{} thread(s) will be terminated", (Object)threadsToStop.length);
        for (StoppableThread thread : threadsToStop) {
            if (thread == null) continue;
            LOG.info(LogMarker.THREADS.getMarker(), "stopping thread {}", (Object)thread.getName());
            thread.stop();
        }
        for (StoppableThread thread : threadsToStop) {
            if (thread == null) continue;
            LOG.info(LogMarker.THREADS.getMarker(), "joining thread {}", (Object)thread.getName());
            thread.join();
        }
        LOG.info(LogMarker.THREADS.getMarker(), "{} thread(s) terminated", (Object)threadsToStop.length);
    }
}

