/*
 * Decompiled with CFR 0.152.
 */
package com.swirlds.common.threading.framework.internal;

import com.swirlds.common.threading.framework.QueueThreadPool;
import com.swirlds.common.threading.framework.config.QueueThreadPoolConfiguration;
import com.swirlds.common.threading.framework.internal.AbstractQueueThreadConfiguration;
import com.swirlds.common.threading.framework.internal.QueueThreadPoolImpl;

public abstract class AbstractQueueThreadPoolConfiguration<C extends AbstractQueueThreadConfiguration<C, T>, T>
extends AbstractQueueThreadConfiguration<QueueThreadPoolConfiguration<T>, T> {
    private static final int DEFAULT_THREAD_COUNT = Runtime.getRuntime().availableProcessors();
    private int threadCount = DEFAULT_THREAD_COUNT;

    protected AbstractQueueThreadPoolConfiguration() {
    }

    protected AbstractQueueThreadPoolConfiguration(AbstractQueueThreadPoolConfiguration<C, T> that) {
        super(that);
        this.threadCount = that.threadCount;
    }

    @Override
    public abstract AbstractQueueThreadPoolConfiguration<C, T> copy();

    protected QueueThreadPool<T> buildQueueThreadPool(boolean start) {
        QueueThreadPoolImpl pool = new QueueThreadPoolImpl(this);
        if (start) {
            pool.start();
        }
        return pool;
    }

    public int getThreadCount() {
        return this.threadCount;
    }

    public C setThreadCount(int threadCount) {
        this.throwIfImmutable();
        this.threadCount = threadCount;
        return (C)this;
    }
}

