/*
 * Decompiled with CFR 0.152.
 */
package com.swirlds.common.threading.locks;

import com.swirlds.common.threading.locks.AutoClosableLock;
import com.swirlds.common.threading.locks.Locked;
import com.swirlds.common.threading.locks.MaybeLocked;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.Condition;
import java.util.concurrent.locks.ReentrantLock;

public class AutoLock
implements AutoClosableLock {
    private final ReentrantLock lock = new ReentrantLock();

    @Override
    public Locked lock() {
        this.lock.lock();
        return this.lock::unlock;
    }

    @Override
    public Locked lockInterruptibly() throws InterruptedException {
        this.lock.lockInterruptibly();
        return this.lock::unlock;
    }

    @Override
    public MaybeLocked tryLock() {
        final boolean locked = this.lock.tryLock();
        return new MaybeLocked(){

            @Override
            public boolean isLockAcquired() {
                return locked;
            }

            @Override
            public void close() {
                if (locked) {
                    AutoLock.this.lock.unlock();
                }
            }
        };
    }

    @Override
    public MaybeLocked tryLock(long time, TimeUnit unit) throws InterruptedException {
        final boolean locked = this.lock.tryLock(time, unit);
        return new MaybeLocked(){

            @Override
            public boolean isLockAcquired() {
                return locked;
            }

            @Override
            public void close() {
                if (locked) {
                    AutoLock.this.lock.unlock();
                }
            }
        };
    }

    @Override
    public Condition newCondition() {
        return this.lock.newCondition();
    }
}

