/*
 * Decompiled with CFR 0.152.
 */
package com.swirlds.common.threading.locks;

import com.swirlds.common.threading.locks.Locked;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;

public class IndexLock {
    private final int parallelism;
    private final Lock[] locks;

    public IndexLock(int parallelism) {
        this.parallelism = parallelism;
        this.locks = new Lock[parallelism];
        for (int lockIndex = 0; lockIndex < parallelism; ++lockIndex) {
            this.locks[lockIndex] = new ReentrantLock();
        }
    }

    public void lock(long index) {
        this.locks[(int)(Math.abs(index) % (long)this.parallelism)].lock();
    }

    public void lock(Object object) {
        int hash = object == null ? 0 : object.hashCode();
        this.lock(hash);
    }

    public void unlock(long index) {
        this.locks[(int)(Math.abs(index) % (long)this.parallelism)].unlock();
    }

    public void unlock(Object object) {
        int hash = object == null ? 0 : object.hashCode();
        this.unlock(hash);
    }

    public Locked autoLock(long index) {
        this.lock(index);
        return () -> this.unlock(index);
    }

    public Locked autoLock(Object object) {
        int hash = object == null ? 0 : object.hashCode();
        return this.autoLock(hash);
    }
}

