/*
 * Decompiled with CFR 0.152.
 */
package com.swirlds.common.threading.pool;

import com.swirlds.common.threading.framework.config.ThreadConfiguration;
import com.swirlds.common.threading.pool.ParallelExecutionException;
import com.swirlds.common.threading.pool.ParallelExecutor;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;

public class CachedPoolParallelExecutor
implements ParallelExecutor {
    private static final Runnable NOOP = () -> {};
    private final ExecutorService threadPool;

    public CachedPoolParallelExecutor(String name) {
        this.threadPool = Executors.newCachedThreadPool(((ThreadConfiguration)((ThreadConfiguration)new ThreadConfiguration().setThreadName(name)).setComponent(name)).buildFactory());
    }

    @Override
    public <T> T doParallel(Callable<T> foregroundTask, Callable<Void> backgroundTask, Runnable onThrow) throws ParallelExecutionException {
        Future<Void> future = this.threadPool.submit(backgroundTask);
        ParallelExecutionException toThrow = null;
        T result = null;
        try {
            result = foregroundTask.call();
        }
        catch (Exception e) {
            toThrow = new ParallelExecutionException(e);
            onThrow.run();
        }
        try {
            future.get();
        }
        catch (InterruptedException | ExecutionException e) {
            if (e instanceof InterruptedException) {
                Thread.currentThread().interrupt();
            }
            if (toThrow == null) {
                toThrow = new ParallelExecutionException(e);
                onThrow.run();
            }
            toThrow.addSuppressed(e);
        }
        if (toThrow != null) {
            throw toThrow;
        }
        return result;
    }

    @Override
    public <T> T doParallel(Callable<T> foregroundTask, Callable<Void> backgroundTask) throws ParallelExecutionException {
        return this.doParallel(foregroundTask, backgroundTask, NOOP);
    }
}

