/*
 * Decompiled with CFR 0.152.
 */
package com.swirlds.common.utility;

public final class ByteUtils {
    private static final long LAST_BYTE_MASK_LONG = 255L;
    private static final int LAST_BYTE_MASK_INT = 255;

    private ByteUtils() {
    }

    public static long byteArrayToLong(byte[] data, int position) {
        return (((long)data[position] & 0xFFL) << 56) + (((long)data[position + 1] & 0xFFL) << 48) + (((long)data[position + 2] & 0xFFL) << 40) + (((long)data[position + 3] & 0xFFL) << 32) + (((long)data[position + 4] & 0xFFL) << 24) + (((long)data[position + 5] & 0xFFL) << 16) + (((long)data[position + 6] & 0xFFL) << 8) + ((long)data[position + 7] & 0xFFL);
    }

    public static byte[] longToByteArray(long value) {
        byte[] data = new byte[8];
        ByteUtils.longToByteArray(value, data, 0);
        return data;
    }

    public static void longToByteArray(long value, byte[] data, int position) {
        data[position] = (byte)(value >> 56);
        data[position + 1] = (byte)(value >> 48);
        data[position + 2] = (byte)(value >> 40);
        data[position + 3] = (byte)(value >> 32);
        data[position + 4] = (byte)(value >> 24);
        data[position + 5] = (byte)(value >> 16);
        data[position + 6] = (byte)(value >> 8);
        data[position + 7] = (byte)value;
    }

    public static int byteArrayToInt(byte[] data, int position) {
        return ((data[position] & 0xFF) << 24) + ((data[position + 1] & 0xFF) << 16) + ((data[position + 2] & 0xFF) << 8) + (data[position + 3] & 0xFF);
    }

    public static byte[] intToByteArray(int value) {
        byte[] data = new byte[4];
        ByteUtils.intToByteArray(value, data, 0);
        return data;
    }

    public static void intToByteArray(int value, byte[] data, int position) {
        data[position] = (byte)(value >> 24);
        data[position + 1] = (byte)(value >> 16);
        data[position + 2] = (byte)(value >> 8);
        data[position + 3] = (byte)value;
    }
}

