/*
 * Decompiled with CFR 0.152.
 */
package com.swirlds.common.bloom.hasher;

import com.swirlds.common.bloom.BloomHasher;
import com.swirlds.common.io.streams.SerializableDataInputStream;
import com.swirlds.common.io.streams.SerializableDataOutputStream;
import com.swirlds.common.utility.NonCryptographicHashing;
import java.io.IOException;

public class LongBloomHasher
implements BloomHasher<Long> {
    private static final long CLASS_ID = 459838435057887938L;

    @Override
    public void hash(Long element, long maxHash, long[] hashes) {
        long runningHash = element;
        for (int index = 0; index < hashes.length; ++index) {
            runningHash = NonCryptographicHashing.hash64(runningHash);
            hashes[index] = Math.abs(runningHash) % maxHash;
        }
    }

    @Override
    public long getClassId() {
        return 459838435057887938L;
    }

    @Override
    public void serialize(SerializableDataOutputStream out) throws IOException {
    }

    @Override
    public void deserialize(SerializableDataInputStream in, int version) throws IOException {
    }

    @Override
    public int getVersion() {
        return 1;
    }

    private static final class ClassVersion {
        public static final int ORIGINAL = 1;

        private ClassVersion() {
        }
    }
}

