/*
 * Decompiled with CFR 0.152.
 */
package com.swirlds.common.constructable;

import com.swirlds.common.Releasable;
import com.swirlds.common.constructable.ClassConstructorPair;
import com.swirlds.common.constructable.ConstructableIgnored;
import com.swirlds.common.constructable.ConstructableRegistryException;
import com.swirlds.common.constructable.RuntimeConstructable;
import com.swirlds.common.constructable.URLClassLoaderWithLookup;
import io.github.classgraph.ClassGraph;
import io.github.classgraph.ClassInfo;
import io.github.classgraph.ScanResult;
import java.lang.invoke.CallSite;
import java.lang.invoke.LambdaMetafactory;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.MethodHandles;
import java.lang.invoke.MethodType;
import java.lang.reflect.Modifier;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Supplier;
import java.util.stream.Stream;
import org.apache.commons.lang3.NotImplementedException;

public abstract class ConstructableRegistry {
    private static Map<Long, ClassConstructorPair> map = new ConcurrentHashMap<Long, ClassConstructorPair>();

    public static Supplier<RuntimeConstructable> getConstructor(long classId) {
        ClassConstructorPair p = map.get(classId);
        if (p == null) {
            return null;
        }
        return p.getConstructor();
    }

    public static <T extends RuntimeConstructable> T createObject(long classId) {
        Supplier<RuntimeConstructable> c = ConstructableRegistry.getConstructor(classId);
        if (c == null) {
            return null;
        }
        return (T)c.get();
    }

    public static synchronized void registerConstructables(String packagePrefix, URLClassLoaderWithLookup additionalClassloader) throws ConstructableRegistryException {
        for (Class<? extends RuntimeConstructable> aClass : ConstructableRegistry.getConstructableClasses(packagePrefix, additionalClassloader)) {
            ConstructableRegistry.registerConstructable(new ClassConstructorPair(aClass, ConstructableRegistry.getConstructorLambda(aClass, additionalClassloader)));
        }
    }

    public static synchronized void registerConstructables(String packagePrefix) throws ConstructableRegistryException {
        ConstructableRegistry.registerConstructables(packagePrefix, null);
    }

    private static synchronized void registerConstructable(Class<? extends RuntimeConstructable> aClass) throws ConstructableRegistryException {
        ConstructableRegistry.registerConstructable(new ClassConstructorPair(aClass, ConstructableRegistry.getConstructorLambda(aClass, null)));
    }

    public static void registerConstructable(ClassConstructorPair pair) throws ConstructableRegistryException {
        ClassConstructorPair old;
        Long classId;
        try {
            RuntimeConstructable obj = pair.getConstructor().get();
            classId = obj.getClassId();
            if (obj instanceof Releasable) {
                try {
                    ((Releasable)((Object)obj)).release();
                }
                catch (NotImplementedException notImplementedException) {}
            }
        }
        catch (Throwable e) {
            throw new ConstructableRegistryException(String.format("Lambda constructor threw an Exception: %s", e.getMessage()), e);
        }
        if ((old = map.get(classId)) != null && !old.classEquals(pair)) {
            throw new ConstructableRegistryException(String.format("Two classes ('%s' and '%s') have the same classId:%d (hex:%s). ClassId must be unique!", old.getConstructableClass().getCanonicalName(), pair.getConstructableClass().getCanonicalName(), classId, Long.toHexString(classId)));
        }
        map.put(classId, pair);
    }

    private static Supplier<RuntimeConstructable> getConstructorLambda(Class<? extends RuntimeConstructable> constructable, URLClassLoaderWithLookup additionalClassloader) throws ConstructableRegistryException {
        Supplier constructor;
        try {
            ConstructableRegistry.class.getModule().addReads(constructable.getModule());
            MethodHandles.Lookup lookup = ConstructableRegistry.getLookup(constructable, additionalClassloader);
            MethodHandle mh = lookup.findConstructor(constructable, MethodType.methodType(Void.TYPE));
            CallSite site = LambdaMetafactory.metafactory(lookup, "get", MethodType.methodType(Supplier.class), mh.type().generic(), mh, mh.type());
            constructor = site.getTarget().invokeExact();
        }
        catch (Throwable throwable) {
            throw new ConstructableRegistryException(String.format("Could not create a lambda for constructor: %s", throwable.getMessage()), throwable);
        }
        return constructor;
    }

    private static MethodHandles.Lookup getLookup(Class<? extends RuntimeConstructable> constructable, URLClassLoaderWithLookup additionalClassloader) throws ConstructableRegistryException {
        if (additionalClassloader == null) {
            return MethodHandles.lookup();
        }
        if (additionalClassloader != null && additionalClassloader.equals(constructable.getClassLoader())) {
            try {
                return additionalClassloader.getLookup();
            }
            catch (Exception e) {
                throw new ConstructableRegistryException("Issue while getting the MethodHandles.Lookup from URLClassLoaderWithLookup", e);
            }
        }
        return MethodHandles.lookup();
    }

    private static List<Class<? extends RuntimeConstructable>> getConstructableClasses(String packagePrefix) throws ConstructableRegistryException {
        return ConstructableRegistry.getConstructableClasses(packagePrefix, null);
    }

    private static List<Class<? extends RuntimeConstructable>> getConstructableClasses(String packagePrefix, URLClassLoaderWithLookup additionalClassloader) throws ConstructableRegistryException {
        LinkedList<Class<? extends RuntimeConstructable>> list = new LinkedList<Class<? extends RuntimeConstructable>>();
        ClassGraph classGraph = new ClassGraph().enableClassInfo().disableDirScanning().whitelistPackages(new String[]{packagePrefix});
        if (additionalClassloader != null) {
            classGraph.addClassLoader((ClassLoader)additionalClassloader);
        }
        try (ScanResult scanResult = classGraph.scan();){
            for (ClassInfo classInfo : scanResult.getClassesImplementing(RuntimeConstructable.class.getCanonicalName())) {
                Class subType = classInfo.loadClass(RuntimeConstructable.class);
                if (ConstructableRegistry.isSkippable(subType)) continue;
                if (!ConstructableRegistry.hasNoArgsConstructor(subType)) {
                    throw new ConstructableRegistryException(String.format("Cannot find no-args constructor for class: %s", subType.getCanonicalName()));
                }
                list.add(subType);
            }
        }
        return list;
    }

    private static boolean isSkippable(Class<? extends RuntimeConstructable> subType) {
        return subType.isInterface() || Modifier.isAbstract(subType.getModifiers()) || subType.isAnnotationPresent(ConstructableIgnored.class);
    }

    private static boolean hasNoArgsConstructor(Class<? extends RuntimeConstructable> constructable) {
        return Stream.of(constructable.getConstructors()).anyMatch(c -> c.getParameterCount() == 0);
    }
}

