/*
 * Decompiled with CFR 0.152.
 */
package com.swirlds.common.crypto;

import com.swirlds.common.crypto.DigestType;
import com.swirlds.common.crypto.Hash;
import java.util.Arrays;
import java.util.Objects;
import java.util.concurrent.Future;

public class Message
implements Comparable<Message> {
    private byte[] payload;
    private int offset;
    private int length;
    private Hash hash;
    private DigestType digestType;
    private Future<Void> future;

    public Message(byte[] payload) {
        this(payload, 0, payload != null ? payload.length : 0, DigestType.SHA_384);
    }

    public Message(byte[] payload, DigestType digestType) {
        this(payload, 0, payload != null ? payload.length : 0, digestType);
    }

    public Message(byte[] payload, int offset) {
        this(payload, offset, payload != null ? payload.length - offset : 0, DigestType.SHA_384);
    }

    public Message(byte[] payload, int offset, DigestType digestType) {
        this(payload, offset, payload != null ? payload.length - offset : 0, digestType);
    }

    public Message(byte[] payload, int offset, int length) {
        this(payload, offset, length, DigestType.SHA_384);
    }

    public Message(byte[] payload, int offset, int length, DigestType digestType) {
        if (payload == null) {
            throw new NullPointerException("payload");
        }
        if (length < 0 || length > payload.length) {
            throw new IllegalArgumentException("length");
        }
        if (offset < 0 || offset > payload.length || offset + length > payload.length) {
            throw new ArrayIndexOutOfBoundsException("offset");
        }
        if (digestType == null) {
            throw new NullPointerException("digestType");
        }
        this.payload = payload;
        this.offset = offset;
        this.length = length;
        this.digestType = digestType;
    }

    public byte[] getPayload() {
        return (byte[])this.payload.clone();
    }

    public byte[] getPayloadDirect() {
        return this.payload;
    }

    public int getOffset() {
        return this.offset;
    }

    public int getLength() {
        return this.length;
    }

    public Hash getHash() {
        return this.hash;
    }

    public void setHash(Hash hash) {
        this.hash = hash;
    }

    public synchronized Future<Void> getFuture() {
        return this.future;
    }

    public synchronized void setFuture(Future<Void> future) {
        if (future == null) {
            throw new NullPointerException("future");
        }
        this.future = future;
        this.notifyAll();
    }

    public synchronized Future<Void> waitForFuture() throws InterruptedException {
        while (this.future == null) {
            this.wait();
        }
        return this.future;
    }

    public DigestType getDigestType() {
        return this.digestType;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof Message)) {
            return false;
        }
        Message that = (Message)obj;
        return this.offset == that.offset && this.length == that.length && Arrays.equals(this.payload, that.payload);
    }

    public int hashCode() {
        int result = Objects.hash(this.offset, this.length);
        result = 31 * result + Arrays.hashCode(this.payload);
        return result;
    }

    @Override
    public int compareTo(Message that) {
        if (this == that) {
            return 0;
        }
        if (that == null) {
            return 1;
        }
        int result = Integer.compare(this.offset, that.offset);
        if (result != 0) {
            return result;
        }
        result = Integer.compare(this.length, that.length);
        if (result != 0) {
            return result;
        }
        return Arrays.compare(this.payload, that.payload);
    }
}

