/*
 * Decompiled with CFR 0.152.
 */
package com.swirlds.common.crypto.engine;

import com.swirlds.common.crypto.engine.OperationProvider;
import com.swirlds.common.threading.futures.WaitingFuture;
import com.swirlds.logging.LogMarker;
import java.security.NoSuchAlgorithmException;
import java.util.ArrayList;
import java.util.List;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public abstract class AsyncOperationHandler<Element, Provider extends OperationProvider>
extends WaitingFuture<Void>
implements Runnable {
    private final List<Element> workItems;
    private final Provider provider;
    private final Logger log;

    public AsyncOperationHandler(List<Element> workItems, Provider provider) {
        this(workItems, false, provider);
    }

    public AsyncOperationHandler(List<Element> workItems, boolean shouldCopy, Provider provider) {
        this.workItems = shouldCopy ? new ArrayList<Element>(workItems) : workItems;
        this.log = LogManager.getLogger(this.getClass());
        this.provider = provider;
    }

    @Override
    public void run() {
        for (Element item : this.workItems) {
            try {
                this.handleWorkItem(this.provider, item);
            }
            catch (RuntimeException | NoSuchAlgorithmException ex) {
                this.log.warn(LogMarker.TESTING_EXCEPTIONS.getMarker(), "Intercepted Uncaught Exception", (Throwable)ex);
            }
        }
        this.done(null);
    }

    protected abstract void handleWorkItem(Provider var1, Element var2) throws NoSuchAlgorithmException;

    protected Logger log() {
        return this.log;
    }
}

