/*
 * Decompiled with CFR 0.152.
 */
package com.swirlds.common.crypto.engine;

import com.swirlds.common.crypto.DigestType;
import com.swirlds.common.crypto.Hash;
import com.swirlds.common.crypto.Message;
import com.swirlds.common.crypto.engine.CachingOperationProvider;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;

public class DigestProvider
extends CachingOperationProvider<Message, Void, Hash, MessageDigest, DigestType> {
    protected Hash compute(byte[] msg) throws NoSuchAlgorithmException {
        return this.compute(msg, DigestType.SHA_384);
    }

    @Override
    protected Hash compute(byte[] msg, DigestType algorithmType) throws NoSuchAlgorithmException {
        if (msg == null) {
            throw new IllegalArgumentException("msg");
        }
        return this.compute(msg, 0, msg.length, algorithmType);
    }

    @Override
    private Hash compute(byte[] msg, int offset, int length) throws NoSuchAlgorithmException {
        return this.compute(msg, offset, length, DigestType.SHA_384);
    }

    private Hash compute(byte[] msg, int offset, int length, DigestType algorithmType) throws NoSuchAlgorithmException {
        MessageDigest algorithm = (MessageDigest)this.loadAlgorithm(algorithmType);
        return new Hash(this.compute(algorithm, msg, offset, length), algorithmType);
    }

    @Override
    protected MessageDigest handleAlgorithmRequired(DigestType algorithmType) throws NoSuchAlgorithmException {
        return MessageDigest.getInstance(algorithmType.algorithmName());
    }

    @Override
    protected Hash handleItem(MessageDigest algorithm, DigestType algorithmType, Message item, Void optionalData) {
        return new Hash(this.compute(algorithm, item.getPayloadDirect(), item.getOffset(), item.getLength()), algorithmType);
    }

    private byte[] compute(MessageDigest algorithm, byte[] msg, int offset, int length) {
        algorithm.reset();
        algorithm.update(msg, offset, length);
        return algorithm.digest();
    }
}

