/*
 * Decompiled with CFR 0.152.
 */
package com.swirlds.common.crypto.engine;

import com.swirlds.common.crypto.CryptographyException;
import com.swirlds.common.crypto.SignatureType;
import com.swirlds.common.crypto.TransactionSignature;
import com.swirlds.common.crypto.engine.CachingOperationProvider;
import com.swirlds.common.crypto.engine.EcdsaSecp256k1Verifier;
import com.swirlds.common.utility.CommonUtils;
import com.swirlds.logging.LogMarker;
import java.nio.ByteBuffer;
import java.security.NoSuchAlgorithmException;

public class EcdsaSecp256k1VerificationProvider
extends CachingOperationProvider<TransactionSignature, Void, Boolean, EcdsaSecp256k1Verifier, SignatureType> {
    protected boolean compute(byte[] message, byte[] signature, byte[] publicKey, SignatureType algorithmType) {
        EcdsaSecp256k1Verifier loadedAlgorithm;
        try {
            loadedAlgorithm = (EcdsaSecp256k1Verifier)this.loadAlgorithm(algorithmType);
        }
        catch (NoSuchAlgorithmException e) {
            throw new CryptographyException(e, LogMarker.ERROR);
        }
        return this.verified(loadedAlgorithm, algorithmType, message, signature, publicKey);
    }

    @Override
    protected EcdsaSecp256k1Verifier handleAlgorithmRequired(SignatureType algorithmType) throws NoSuchAlgorithmException {
        return new EcdsaSecp256k1Verifier();
    }

    @Override
    protected Boolean handleItem(EcdsaSecp256k1Verifier algorithm, SignatureType algorithmType, TransactionSignature item, Void optionalData) {
        return this.compute(algorithm, algorithmType, item);
    }

    @Override
    private boolean compute(EcdsaSecp256k1Verifier algorithm, SignatureType algorithmType, TransactionSignature sig) {
        byte[] payload = sig.getContentsDirect();
        byte[] expandedPublicKey = sig.getExpandedPublicKey();
        ByteBuffer buffer = ByteBuffer.wrap(payload);
        ByteBuffer pkBuffer = expandedPublicKey != null && expandedPublicKey.length > 0 ? ByteBuffer.wrap(expandedPublicKey) : buffer;
        byte[] signature = new byte[sig.getSignatureLength()];
        byte[] publicKey = new byte[sig.getPublicKeyLength()];
        byte[] message = new byte[sig.getMessageLength()];
        buffer.position(sig.getMessageOffset()).get(message).position(sig.getSignatureOffset()).get(signature);
        pkBuffer.position(sig.getPublicKeyOffset()).get(publicKey);
        return this.verified(algorithm, algorithmType, message, signature, publicKey);
    }

    private boolean verified(EcdsaSecp256k1Verifier algorithm, SignatureType algorithmType, byte[] message, byte[] signature, byte[] publicKey) {
        boolean isValid = algorithm.verify(signature, message, publicKey);
        if (!isValid && this.log().isDebugEnabled()) {
            this.log().debug(LogMarker.TESTING_EXCEPTIONS.getMarker(), "Adv Crypto Subsystem: Signature Verification Failure for signature type {} [ publicKey = {}, signature = {} ]", (Object)algorithmType, (Object)CommonUtils.hex(publicKey), (Object)CommonUtils.hex(signature));
        }
        return isValid;
    }
}

