/*
 * Decompiled with CFR 0.152.
 */
package com.swirlds.common.crypto.internal;

public interface CryptographySettings {
    public static final String DEFAULT_KEYSTORE_PASSWORD = "password";

    public static CryptographySettings getDefaultSettings() {
        return new CryptographySettings(){

            @Override
            public double getCpuVerifierThreadRatio() {
                return 0.5;
            }

            @Override
            public double getCpuDigestThreadRatio() {
                return 0.5;
            }

            @Override
            public int getCpuVerifierQueueSize() {
                return 100;
            }

            @Override
            public int getCpuDigestQueueSize() {
                return 100;
            }

            @Override
            public boolean forceCpu() {
                return true;
            }

            @Override
            public String getKeystorePassword() {
                return CryptographySettings.DEFAULT_KEYSTORE_PASSWORD;
            }
        };
    }

    public double getCpuVerifierThreadRatio();

    public double getCpuDigestThreadRatio();

    public int getCpuVerifierQueueSize();

    public int getCpuDigestQueueSize();

    public boolean forceCpu();

    public String getKeystorePassword();

    default public int computeCpuVerifierThreadCount() {
        int numberOfCores = Runtime.getRuntime().availableProcessors();
        double interimThreadCount = Math.ceil((double)numberOfCores * this.getCpuVerifierThreadRatio());
        return interimThreadCount >= 1.0 ? (int)interimThreadCount : 1;
    }

    default public int computeCpuDigestThreadCount() {
        int numberOfCores = Runtime.getRuntime().availableProcessors();
        double interimThreadCount = Math.ceil((double)numberOfCores * this.getCpuDigestThreadRatio());
        return interimThreadCount >= 1.0 ? (int)interimThreadCount : 1;
    }
}

