/*
 * Decompiled with CFR 0.152.
 */
package com.swirlds.common.internal;

import com.swirlds.common.system.Address;
import com.swirlds.common.system.AddressBook;
import java.io.File;
import java.util.List;

public class ApplicationDefinition {
    private final String swirldName;
    private final String[] appParameters;
    private final String appJarFileName;
    private final String mainClassName;
    private final File appJarPath;
    private final AddressBook addressBook;
    private byte[] masterKey;
    private byte[] swirldId;

    public ApplicationDefinition(String swirldName, String[] appParameters, String appJarFileName, String mainClassName, File appJarPath, List<Address> bookData) {
        this.swirldName = swirldName;
        this.appParameters = appParameters;
        this.appJarFileName = appJarFileName;
        this.mainClassName = mainClassName;
        this.appJarPath = appJarPath;
        this.addressBook = new AddressBook(bookData);
    }

    public String getSwirldName() {
        return this.swirldName;
    }

    public String[] getAppParameters() {
        return this.appParameters;
    }

    public String getAppJarFileName() {
        return this.appJarFileName;
    }

    public String getMainClassName() {
        return this.mainClassName;
    }

    public String getApplicationName() {
        return this.mainClassName.substring(0, this.mainClassName.length() - 4);
    }

    public File getAppJarPath() {
        return this.appJarPath;
    }

    public AddressBook getAddressBook() {
        return this.addressBook;
    }

    public byte[] getMasterKey() {
        return this.masterKey;
    }

    public byte[] getSwirldId() {
        return this.swirldId;
    }

    public void setMasterKey(byte[] masterKey) {
        this.masterKey = masterKey;
    }

    public void setSwirldId(byte[] swirldId) {
        this.swirldId = swirldId;
    }
}

