/*
 * Decompiled with CFR 0.152.
 */
package com.swirlds.common.io.streams;

import com.swirlds.common.io.streams.DebuggableMerkleDataInputStream;
import com.swirlds.common.io.streams.MerkleDataInputStream;
import com.swirlds.logging.LogMarker;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public final class StreamDebugUtils {
    private static final Logger LOG = LogManager.getLogger(StreamDebugUtils.class);

    private StreamDebugUtils() {
    }

    public static <T> T deserializeAndDebugOnFailure(InputStreamBuilder inputStreamBuilder, Deserializer<T> deserializer, Runnable failureCallback) throws IOException {
        return StreamDebugUtils.deserializeAndDebugOnFailure(inputStreamBuilder, null, deserializer, failureCallback);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static <T> T deserializeAndDebugOnFailure(InputStreamBuilder inputStreamBuilder, File externalDirectory, Deserializer<T> deserializer, Runnable failureCallback) throws IOException {
        try (InputStream baseStream = inputStreamBuilder.buildStream();){
            MerkleDataInputStream in2 = new MerkleDataInputStream(baseStream, externalDirectory);
            T t = deserializer.deserialize(in2);
            return t;
        }
        catch (Throwable ex) {
            LOG.error(LogMarker.EXCEPTION.getMarker(), "Deserialization failure. Will re-attempt deserialization with extra debug information.", ex);
            DebuggableMerkleDataInputStream in22 = null;
            try (InputStream baseStream2 = inputStreamBuilder.buildStream();){
                in22 = new DebuggableMerkleDataInputStream(baseStream2, externalDirectory);
                deserializer.deserialize(in22);
                throw ex;
            }
            catch (Throwable innerEx) {
                LOG.error(LogMarker.EXCEPTION.getMarker(), "Deserialization re-attempt also encountered a failure.", innerEx);
                throw ex;
            }
            finally {
                if (in22 != null) {
                    LOG.error(LogMarker.EXCEPTION.getMarker(), "Deserialization stack trace:\n{}", (Object)in22.getFormattedStackTrace());
                }
                if (failureCallback != null) {
                    failureCallback.run();
                }
            }
        }
    }

    public static interface InputStreamBuilder {
        public InputStream buildStream() throws IOException;
    }

    @FunctionalInterface
    public static interface Deserializer<T> {
        public T deserialize(MerkleDataInputStream var1) throws IOException;
    }
}

