/*
 * Decompiled with CFR 0.152.
 */
package com.swirlds.common.io.streams.internal;

import com.swirlds.common.io.SelfSerializable;
import com.swirlds.common.io.streams.SerializableDataInputStream;
import com.swirlds.common.io.streams.SerializableDataOutputStream;
import java.io.IOException;
import java.util.BitSet;
import org.apache.commons.lang3.builder.ToStringBuilder;

public class MerkleTreeSerializationOptions
implements SelfSerializable {
    private static final long CLASS_ID = 8549157183839407052L;
    private static final int CLASS_VERSION = 1;
    public static final int MAX_LENGTH_BYTES = 128;
    private static final int WRITE_HASHES_BIT = 0;
    private static final int EXTERNAL_BIT = 1;
    private BitSet options = new BitSet();

    public static MerkleTreeSerializationOptions builder() {
        return new MerkleTreeSerializationOptions();
    }

    public static MerkleTreeSerializationOptions defaults() {
        return MerkleTreeSerializationOptions.builder();
    }

    @Override
    public void deserialize(SerializableDataInputStream in, int version) throws IOException {
        this.options = BitSet.valueOf(in.readByteArray(128));
    }

    @Override
    public void serialize(SerializableDataOutputStream out) throws IOException {
        out.writeByteArray(this.options.toByteArray());
    }

    public MerkleTreeSerializationOptions setWriteHashes(boolean writeHashes) {
        this.options.set(0, writeHashes);
        return this;
    }

    public boolean getWriteHashes() {
        return this.options.get(0);
    }

    public MerkleTreeSerializationOptions setExternal(boolean external) {
        this.options.set(1, external);
        return this;
    }

    public boolean isExternal() {
        return this.options.get(1);
    }

    public String toString() {
        return new ToStringBuilder((Object)this).append("external", this.isExternal()).append("writeHashes", this.getWriteHashes()).toString();
    }

    @Override
    public long getClassId() {
        return 8549157183839407052L;
    }

    @Override
    public int getVersion() {
        return 1;
    }
}

