/*
 * Decompiled with CFR 0.152.
 */
package com.swirlds.common.merkle.route;

import com.swirlds.common.merkle.route.MerkleRoute;
import com.swirlds.common.merkle.route.internal.BinaryMerkleRoute;
import com.swirlds.common.merkle.route.internal.UncompressedMerkleRoute;
import java.util.List;

public final class MerkleRouteFactory {
    private static MerkleRoute emptyRoute = new BinaryMerkleRoute();

    private MerkleRouteFactory() {
    }

    public static void setRouteEncodingStrategy(MerkleRouteEncoding encoding) {
        switch (encoding) {
            case BINARY_COMPRESSION: {
                emptyRoute = new BinaryMerkleRoute();
                break;
            }
            case UNCOMPRESSED: {
                emptyRoute = new UncompressedMerkleRoute();
                break;
            }
            default: {
                throw new IllegalArgumentException("Unhandled type: " + encoding);
            }
        }
    }

    public static MerkleRoute getEmptyRoute() {
        return emptyRoute;
    }

    public static MerkleRoute buildRoute(List<Integer> steps) {
        return MerkleRouteFactory.getEmptyRoute().extendRoute(steps);
    }

    public static MerkleRoute buildRoute(int ... steps) {
        return MerkleRouteFactory.getEmptyRoute().extendRoute(steps);
    }

    public static enum MerkleRouteEncoding {
        BINARY_COMPRESSION,
        UNCOMPRESSED;

    }
}

