/*
 * Decompiled with CFR 0.152.
 */
package com.swirlds.common.merkle.route;

import com.swirlds.common.merkle.MerkleInternal;
import com.swirlds.common.merkle.MerkleNode;
import com.swirlds.common.merkle.exceptions.MerkleRouteException;
import com.swirlds.common.merkle.route.MerkleRoute;
import java.util.Iterator;
import java.util.NoSuchElementException;

public class MerkleRouteIterator
implements Iterator<MerkleNode> {
    private MerkleNode prev;
    private MerkleNode next;
    private boolean hasNext;
    private final Iterator<Integer> stepIterator;

    public MerkleRouteIterator(MerkleNode root, MerkleRoute route) {
        this.next = root;
        this.hasNext = true;
        this.stepIterator = route.iterator();
    }

    private static MerkleNode getChildAtIndex(MerkleNode parent, int index) {
        if (parent == null) {
            throw new MerkleRouteException("Invalid route, null value prematurely encountered.");
        }
        if (parent.isLeaf()) {
            throw new MerkleRouteException("Invalid route, leaf node prematurely encountered.");
        }
        MerkleInternal internal = (MerkleInternal)parent.cast();
        if (internal.getNumberOfChildren() <= index) {
            throw new MerkleRouteException("Invalid route, index exceeds child count.");
        }
        return internal.getChild(index);
    }

    private void findNext() {
        if (this.hasNext || !this.stepIterator.hasNext()) {
            return;
        }
        this.next = MerkleRouteIterator.getChildAtIndex(this.prev, this.stepIterator.next());
        this.hasNext = true;
    }

    @Override
    public boolean hasNext() {
        this.findNext();
        return this.hasNext;
    }

    @Override
    public MerkleNode next() {
        if (!this.hasNext()) {
            throw new NoSuchElementException();
        }
        this.prev = this.next;
        this.hasNext = false;
        return this.prev;
    }

    public MerkleNode getLast() {
        MerkleNode last = this.next;
        while (this.hasNext()) {
            last = this.next();
        }
        return last;
    }
}

