/*
 * Decompiled with CFR 0.152.
 */
package com.swirlds.common.merkle.utility;

import com.swirlds.common.merkle.MerkleNode;
import com.swirlds.common.merkle.exceptions.IllegalChildIndexException;
import com.swirlds.common.merkle.utility.AbstractMerkleInternal;

public abstract class AbstractBinaryMerkleInternal
extends AbstractMerkleInternal {
    private MerkleNode left;
    private MerkleNode right;
    private static final int MIN_BINARY_CHILD_COUNT = 0;
    private static final int BINARY_CHILD_COUNT = 2;

    protected AbstractBinaryMerkleInternal() {
        super(false);
    }

    protected AbstractBinaryMerkleInternal(AbstractBinaryMerkleInternal other) {
        super(other);
    }

    @Override
    public final int getNumberOfChildren() {
        return 2;
    }

    @Override
    public final int getMinimumChildCount(int version) {
        return 0;
    }

    @Override
    public final int getMaximumChildCount(int version) {
        return 2;
    }

    @Override
    public <T extends MerkleNode> T getChild(int index) {
        if (index == 0) {
            return (T)this.left;
        }
        if (index == 1) {
            return (T)this.right;
        }
        throw new IllegalChildIndexException(0, 1, index);
    }

    @Override
    protected final void setChildInternal(int index, MerkleNode child) {
        if (index == 0) {
            this.left = child;
        } else if (index == 1) {
            this.right = child;
        } else {
            throw new IllegalChildIndexException(0, 1, index);
        }
    }

    public <T extends MerkleNode> void setLeft(T left) {
        this.setChild(0, left);
    }

    public <T extends MerkleNode> T getLeft() {
        return (T)this.left;
    }

    public <T extends MerkleNode> void setRight(T right) {
        this.setChild(1, right);
    }

    public <T extends MerkleNode> T getRight() {
        return (T)this.right;
    }

    @Override
    protected final void allocateSpaceForChild(int index) {
    }

    @Override
    protected final void checkChildIndexIsValid(int index) {
    }

    @Override
    public abstract AbstractBinaryMerkleInternal copy();

    private static class ChildIndices {
        public static final int LEFT = 0;
        public static final int RIGHT = 1;

        private ChildIndices() {
        }
    }
}

