/*
 * Decompiled with CFR 0.152.
 */
package com.swirlds.common.merkle.utility;

import com.swirlds.common.AbstractHashable;
import com.swirlds.common.exceptions.ReferenceCountException;
import com.swirlds.common.merkle.MerkleNode;
import com.swirlds.common.merkle.exceptions.MerkleRouteException;
import com.swirlds.common.merkle.route.MerkleRoute;
import com.swirlds.common.merkle.route.MerkleRouteFactory;
import com.swirlds.common.merkle.utility.MerkleUtils;
import java.beans.Transient;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.IntUnaryOperator;

public abstract class AbstractMerkleNode
extends AbstractHashable
implements MerkleNode {
    private boolean immutable;
    private MerkleRoute route;
    protected final AtomicInteger referenceCount = new AtomicInteger(0);
    private static final IntUnaryOperator increment = current -> {
        if (current < 0) {
            return current;
        }
        return current + 1;
    };
    private static final IntUnaryOperator decrement = current -> {
        if (current <= 0) {
            return current;
        }
        if (current == 1) {
            return -1;
        }
        return current - 1;
    };
    private static final IntUnaryOperator release = current -> {
        if (current != 0) {
            return current;
        }
        return -1;
    };

    protected AbstractMerkleNode() {
        this.immutable = false;
        this.route = MerkleRouteFactory.getEmptyRoute();
    }

    protected AbstractMerkleNode(AbstractMerkleNode that) {
        this.route = that.getRoute();
    }

    @Override
    public final boolean isImmutable() {
        return this.immutable;
    }

    @Transient
    protected final void setImmutable(boolean immutable) {
        this.immutable = immutable;
    }

    @Override
    public final void incrementReferenceCount() {
        int previousValue = this.referenceCount.getAndUpdate(increment);
        if (previousValue < 0) {
            throw new ReferenceCountException("object can not be reserved after it has been destroyed");
        }
    }

    @Override
    public final void decrementReferenceCount() {
        int previousValue = this.referenceCount.getAndUpdate(decrement);
        if (previousValue < 0) {
            throw new ReferenceCountException("object can not released after it has been destroyed");
        }
        if (previousValue == 0) {
            throw new ReferenceCountException("object can not have reference count decremented if it is 0");
        }
        if (previousValue == 1) {
            this.releaseInternal();
        }
    }

    @Override
    public final void release() {
        int previousValue = this.referenceCount.getAndUpdate(release);
        if (previousValue < 0) {
            throw new ReferenceCountException("object can not released after it has been destroyed");
        }
        if (previousValue > 0) {
            throw new ReferenceCountException("Nodes can only be released when the reference count equals 0. count = " + previousValue);
        }
        this.releaseInternal();
    }

    protected void releaseInternal() {
        this.onRelease();
    }

    @Override
    public int getReferenceCount() {
        return this.referenceCount.get();
    }

    @Override
    public final boolean isReleased() {
        return this.referenceCount.get() == -1;
    }

    protected void onRelease() {
    }

    @Override
    public final MerkleRoute getRoute() {
        return this.route;
    }

    @Override
    public void setRoute(MerkleRoute route) {
        if (this.getRoute() != route && !this.getRoute().equals(route) && this.getReferenceCount() > 1) {
            throw new MerkleRouteException("Routes can not be set unless the reference count is 0 or 1. " + MerkleUtils.merkleDebugString(this));
        }
        this.route = route;
    }

    @Override
    public abstract AbstractMerkleNode copy();
}

