/*
 * Decompiled with CFR 0.152.
 */
package com.swirlds.common.merkle.utility;

import com.swirlds.common.merkle.MerkleNode;
import com.swirlds.common.merkle.exceptions.IllegalChildIndexException;
import com.swirlds.common.merkle.utility.AbstractMerkleInternal;
import java.util.ArrayList;
import java.util.List;

public abstract class AbstractNaryMerkleInternal
extends AbstractMerkleInternal {
    private final ArrayList<MerkleNode> children;

    protected AbstractNaryMerkleInternal() {
        super(true);
        this.children = new ArrayList(Math.min(0, this.getMinimumChildCount(this.getVersion())));
    }

    protected AbstractNaryMerkleInternal(int initialSize) {
        super(true);
        if (initialSize > 64) {
            throw new IllegalChildIndexException(0, 64, initialSize);
        }
        this.children = new ArrayList(initialSize);
    }

    protected AbstractNaryMerkleInternal(AbstractNaryMerkleInternal that) {
        super(that);
        this.children = new ArrayList(that.getNumberOfChildren());
    }

    @Override
    public int getNumberOfChildren() {
        return this.children.size();
    }

    @Override
    public <T extends MerkleNode> T getChild(int index) {
        if (this.children.size() <= index || index < 0) {
            this.checkChildIndexIsValid(index);
            return null;
        }
        return (T)this.children.get(index);
    }

    @Override
    protected final void setChildInternal(int index, MerkleNode child) {
        this.children.set(index, child);
    }

    @Override
    protected final void allocateSpaceForChild(int index) {
        for (int i = this.children.size(); i <= index; ++i) {
            this.children.add(null);
        }
    }

    @Override
    public void addDeserializedChildren(List<MerkleNode> children, int version) {
        this.children.clear();
        super.addDeserializedChildren(children, version);
    }

    @Override
    protected final void checkChildIndexIsValid(int index) {
        int maxSize = Math.min(this.getMaximumChildCount(this.getVersion()), 64);
        if (index < 0 || index >= maxSize) {
            throw new IllegalChildIndexException(0, maxSize - 1, index);
        }
    }

    @Override
    public abstract AbstractNaryMerkleInternal copy();
}

