/*
 * Decompiled with CFR 0.152.
 */
package com.swirlds.common.merkle.utility;

import com.swirlds.common.crypto.CryptoFactory;
import com.swirlds.common.crypto.Hash;
import com.swirlds.common.crypto.Hashable;
import com.swirlds.common.merkle.MerkleInternal;
import com.swirlds.common.merkle.MerkleNode;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;

public final class MerkleUtils {
    private MerkleUtils() {
    }

    public static void invalidateTree(MerkleNode root) {
        if (root == null) {
            return;
        }
        root.treeIterator().setFilter(node -> !node.isSelfHashing()).setDescendantFilter(node -> !node.isSelfHashing()).forEachRemaining(Hashable::invalidateHash);
    }

    public static Hash rehashTree(MerkleNode root) {
        if (root != null) {
            MerkleUtils.invalidateTree(root);
            Future<Hash> future = CryptoFactory.getInstance().digestTreeAsync(root);
            try {
                return future.get();
            }
            catch (InterruptedException | ExecutionException e) {
                Thread.currentThread().interrupt();
            }
        }
        return null;
    }

    private static void buildMerkleString(StringBuilder sb, MerkleNode node, int depth, int indexInParent, int parentNumberOfChildren, String indentation, int maxDepth, boolean printNodeDescription) {
        if (parentNumberOfChildren > 0) {
            sb.append((String)indentation).append("  |");
            indentation = indexInParent < parentNumberOfChildren - 1 ? (String)indentation + "  |" : (String)indentation + "   ";
        }
        if (parentNumberOfChildren == 0) {
            sb.append("-(root) ");
        } else {
            sb.append("-(").append(indexInParent).append(") ");
        }
        if (node == null) {
            sb.append("null\n");
        } else {
            String[] classElements = node.getClass().toString().split("\\.");
            sb.append(classElements[classElements.length - 1]).append(": " + (printNodeDescription ? node.toString() : ""));
            if (node.isLeaf()) {
                sb.append(node.toString()).append("\n");
            } else {
                MerkleInternal internal = (MerkleInternal)node.cast();
                if (maxDepth > 0 && depth + 1 > maxDepth) {
                    sb.append("...\n");
                } else {
                    sb.append("\n");
                    for (int childIndex = 0; childIndex < internal.getNumberOfChildren(); ++childIndex) {
                        MerkleUtils.buildMerkleString(sb, internal.getChild(childIndex), depth + 1, childIndex, internal.getNumberOfChildren(), (String)indentation, maxDepth, printNodeDescription);
                    }
                }
            }
        }
    }

    public static String getMerkleString(MerkleNode root) {
        return MerkleUtils.getMerkleString(root, false);
    }

    public static String getMerkleString(MerkleNode root, boolean printNodeDescription) {
        return MerkleUtils.getMerkleString(root, -1, printNodeDescription);
    }

    public static String getMerkleString(MerkleNode root, int maxDepth, boolean printNodeDescription) {
        if (root == null) {
            return "-(root) null";
        }
        StringBuilder sb = new StringBuilder();
        MerkleUtils.buildMerkleString(sb, root, 1, 0, 0, "", maxDepth, printNodeDescription);
        return sb.toString();
    }

    public static String merkleDebugString(MerkleNode node) {
        StringBuilder sb = new StringBuilder();
        sb.append("(");
        if (node == null) {
            sb.append("null");
        } else {
            sb.append(node.getClass().getName());
            sb.append(": route = ").append(node.getRoute());
            sb.append(", released = ").append(node.isReleased());
            sb.append(", ref count = ").append(node.getReferenceCount());
            sb.append(", immutable = ").append(node.isImmutable());
            if (!node.isLeaf()) {
                sb.append(", child count = ").append(node.asInternal().getNumberOfChildren());
            }
        }
        sb.append(")");
        return sb.toString();
    }

    public static int findChildPositionInParent(MerkleInternal parent, MerkleNode child) {
        for (int childIndex = 0; childIndex < parent.getNumberOfChildren(); ++childIndex) {
            if (child != parent.getChild(childIndex)) continue;
            return childIndex;
        }
        throw new IllegalStateException("node is not a child of the given parent");
    }
}

