/*
 * Decompiled with CFR 0.152.
 */
package com.swirlds.common.statistics;

import com.swirlds.common.statistics.StatSettings;

public final class StatSettingsFactory {
    private static StatSettings settings;

    private StatSettingsFactory() {
    }

    public static synchronized void configure(StatSettings settings) {
        StatSettingsFactory.settings = settings;
    }

    public static synchronized StatSettings get() {
        if (settings == null) {
            settings = StatSettingsFactory.getDefaultSettings();
        }
        return settings;
    }

    private static StatSettings getDefaultSettings() {
        return new StatSettings(){

            @Override
            public int getBufferSize() {
                return 100;
            }

            @Override
            public double getRecentSeconds() {
                return 63.0;
            }

            @Override
            public double getSkipSeconds() {
                return 60.0;
            }
        };
    }
}

