/*
 * Decompiled with CFR 0.152.
 */
package com.swirlds.common.statistics.internal;

import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.IntBinaryOperator;
import java.util.function.IntUnaryOperator;

public class StatsBuffer {
    private static final IntBinaryOperator INC_BY_ONE_WITHIN_MAX = (value, max) -> {
        if (value < max) {
            return value + 1;
        }
        return value;
    };
    private static final IntUnaryOperator DIVIDE_NUM_BY_TWO = value -> value / 2;
    private double start = -1.0;
    private final double startDelay;
    private final double binSeconds;
    private final int maxBins;
    private final double[] xMins;
    private final double[] xMaxs;
    private final double[] yMins;
    private final double[] yMaxs;
    private final double[] yAvgs;
    private final double[] yVars;
    private final AtomicInteger numBins;
    private int firstBin = 0;
    private int currBin = -1;
    private long numPerBin = 1L;
    private long numLastBin = 0L;

    public StatsBuffer(int maxBins, double recentSeconds, double startDelay) {
        this.maxBins = maxBins + maxBins % 2;
        this.binSeconds = recentSeconds / (double)maxBins;
        this.startDelay = startDelay;
        this.xMins = new double[this.maxBins];
        this.xMaxs = new double[this.maxBins];
        this.yMins = new double[this.maxBins];
        this.yMaxs = new double[this.maxBins];
        this.yAvgs = new double[this.maxBins];
        this.yVars = new double[this.maxBins];
        this.numBins = new AtomicInteger();
    }

    public int numBins() {
        return this.numBins.get();
    }

    public double xAvg(int i) {
        int ii = (this.firstBin + i) % this.numBins();
        return (this.xMins[ii] + this.xMaxs[ii]) / 2.0;
    }

    public double yAvg(int i) {
        int ii = (this.firstBin + i) % this.numBins();
        return this.yAvgs[ii];
    }

    public double xMin(int i) {
        int ii = (this.firstBin + i) % this.numBins();
        return this.xMins[ii];
    }

    public double yMin(int i) {
        int ii = (this.firstBin + i) % this.numBins();
        return this.yMins[ii];
    }

    public double xMax(int i) {
        int ii = (this.firstBin + i) % this.numBins();
        return this.xMaxs[ii];
    }

    public double yMax(int i) {
        int ii = (this.firstBin + i) % this.numBins();
        return this.yMaxs[ii];
    }

    public double yStd(int i) {
        int ii = (this.firstBin + i) % this.numBins();
        return Math.sqrt(this.yVars[ii]);
    }

    public double yStdMostRecent() {
        int currNumBins = this.numBins();
        if (currNumBins > 0) {
            int ii = this.currBin % currNumBins;
            return Math.sqrt(this.yVars[ii]);
        }
        return 0.0;
    }

    public double yMinMostRecent() {
        int currNumBins = this.numBins();
        if (currNumBins > 0) {
            int ii = this.currBin % currNumBins;
            return this.yMins[ii];
        }
        return 0.0;
    }

    public double yMaxMostRecent() {
        int currNumBins = this.numBins();
        if (currNumBins > 0) {
            int ii = this.currBin % currNumBins;
            return this.yMaxs[ii];
        }
        return 0.0;
    }

    public double xMin() {
        double v = Double.MAX_VALUE;
        for (int i = 0; i < this.numBins(); ++i) {
            v = Math.min(v, this.xMins[(this.firstBin + i) % this.maxBins]);
        }
        return v;
    }

    public double xMax() {
        double v = -1.7976931348623157E308;
        for (int i = 0; i < this.numBins(); ++i) {
            v = Math.max(v, this.xMaxs[(this.firstBin + i) % this.maxBins]);
        }
        return v;
    }

    public double yMin() {
        double v = Double.MAX_VALUE;
        for (int i = 0; i < this.numBins(); ++i) {
            v = Math.min(v, this.yMins[(this.firstBin + i) % this.maxBins]);
        }
        return v;
    }

    public double yMax() {
        double v = -1.7976931348623157E308;
        for (int i = 0; i < this.numBins(); ++i) {
            v = Math.max(v, this.yMaxs[(this.firstBin + i) % this.maxBins]);
        }
        return v;
    }

    public double xNow() {
        return (double)System.nanoTime() * 1.0E-9;
    }

    private void addToBin(double x, double y) {
        ++this.numLastBin;
        long n = this.numLastBin;
        this.xMins[this.currBin] = Math.min(this.xMins[this.currBin], x);
        this.xMaxs[this.currBin] = Math.max(this.xMaxs[this.currBin], x);
        this.yMins[this.currBin] = Math.min(this.yMins[this.currBin], y);
        this.yMaxs[this.currBin] = Math.max(this.yMaxs[this.currBin], y);
        this.yAvgs[this.currBin] = this.yAvgs[this.currBin] * (double)(n - 1L) / (double)n + y / (double)n;
        double d = y - this.yAvgs[this.currBin];
        this.yVars[this.currBin] = this.yVars[this.currBin] * (double)(n - 1L) / (double)n + d * d / (double)(n - 1L);
    }

    public void createBin(double x, double y) {
        int i = (this.currBin + 1) % this.maxBins;
        this.xMins[i] = x;
        this.xMaxs[i] = x;
        this.yMins[i] = y;
        this.yMaxs[i] = y;
        this.yAvgs[i] = y;
        this.yVars[i] = 0.0;
        this.numLastBin = 1L;
        this.currBin = i;
        if (this.numBins() < this.maxBins) {
            this.numBins.getAndAccumulate(this.maxBins, INC_BY_ONE_WITHIN_MAX);
        } else if (this.binSeconds > 0.0) {
            this.firstBin = (this.firstBin + 1) % this.maxBins;
        }
    }

    public void recordValue(double y) {
        double x = this.xNow();
        if (this.start == -1.0) {
            this.start = x;
        }
        if (x - this.start < this.startDelay) {
            return;
        }
        if (this.numBins() == 0) {
            this.createBin(x, y);
        } else if (this.binSeconds > 0.0 && x < this.xMins[this.currBin] + this.binSeconds) {
            this.addToBin(x, y);
        } else if (this.binSeconds > 0.0) {
            this.createBin(x, y);
        } else if (this.numLastBin < this.numPerBin) {
            this.addToBin(x, y);
        } else if (this.numBins() + 1 < this.maxBins) {
            this.createBin(x, y);
        } else {
            this.createBin(x, y);
            int currNumBins = this.numBins();
            for (int i = 0; i < currNumBins / 2 && 2 * i + 1 < this.maxBins; ++i) {
                int j = 2 * i;
                int k = 2 * i + 1;
                this.xMins[i] = Math.min(this.xMins[j], this.xMins[k]);
                this.xMaxs[i] = Math.max(this.xMaxs[j], this.xMaxs[k]);
                this.yMins[i] = Math.min(this.yMins[j], this.yMins[k]);
                this.yMaxs[i] = Math.max(this.yMaxs[j], this.yMaxs[k]);
                this.yAvgs[i] = (this.yAvgs[j] + this.yAvgs[k]) / 2.0;
                double dj = this.yAvgs[j] - this.yAvgs[i];
                double dk = this.yAvgs[k] - this.yAvgs[i];
                this.yVars[i] = (this.yVars[j] + this.yVars[k] + dj * dj + dk * dk) / 2.0;
            }
            int newNumBins = this.numBins.updateAndGet(DIVIDE_NUM_BY_TWO);
            this.currBin = newNumBins - 1;
            this.numPerBin *= 2L;
            this.numLastBin = this.numPerBin;
        }
    }
}

