/*
 * Decompiled with CFR 0.152.
 */
package com.swirlds.common.stream;

import com.swirlds.common.crypto.Hash;
import com.swirlds.common.crypto.RunningHashable;
import com.swirlds.common.crypto.SerializableHashable;
import com.swirlds.common.stream.LinkedObjectStream;
import java.util.Objects;

public abstract class AbstractLinkedObjectStream<T extends RunningHashable & SerializableHashable>
implements LinkedObjectStream<T> {
    private LinkedObjectStream<T> nextStream;

    protected AbstractLinkedObjectStream() {
    }

    protected AbstractLinkedObjectStream(LinkedObjectStream<T> nextStream) {
        this();
        this.nextStream = nextStream;
    }

    @Override
    public void setRunningHash(Hash hash) {
        if (this.nextStream != null) {
            this.nextStream.setRunningHash(hash);
        }
    }

    @Override
    public void addObject(T t) {
        if (this.nextStream != null) {
            this.nextStream.addObject((RunningHashable)Objects.requireNonNull(t));
        }
    }

    @Override
    public void clear() {
        if (this.nextStream != null) {
            this.nextStream.clear();
        }
    }

    @Override
    public void close() {
        if (this.nextStream != null) {
            this.nextStream.close();
        }
    }
}

