/*
 * Decompiled with CFR 0.152.
 */
package com.swirlds.common.stream;

import com.swirlds.common.crypto.CryptoFactory;
import com.swirlds.common.crypto.Cryptography;
import com.swirlds.common.crypto.DigestType;
import com.swirlds.common.crypto.Hash;
import com.swirlds.common.crypto.RunningHashable;
import com.swirlds.common.crypto.SerializableHashable;
import com.swirlds.common.stream.AbstractLinkedObjectStream;
import com.swirlds.common.stream.LinkedObjectStream;
import com.swirlds.logging.LogMarker;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class RunningHashCalculatorForStream<T extends RunningHashable & SerializableHashable>
extends AbstractLinkedObjectStream<T> {
    private static final Logger LOGGER = LogManager.getLogger();
    private Hash runningHash;
    private final Cryptography cryptography;

    public RunningHashCalculatorForStream() {
        this.cryptography = CryptoFactory.getInstance();
    }

    public RunningHashCalculatorForStream(LinkedObjectStream<T> nextStream) {
        super(nextStream);
        this.cryptography = CryptoFactory.getInstance();
    }

    public RunningHashCalculatorForStream(Cryptography cryptography) {
        this.cryptography = cryptography;
    }

    public RunningHashCalculatorForStream(LinkedObjectStream<T> nextStream, Cryptography cryptography) {
        super(nextStream);
        this.cryptography = cryptography;
    }

    @Override
    public void setRunningHash(Hash hash) {
        this.runningHash = hash;
        super.setRunningHash(hash);
        LOGGER.info(LogMarker.OBJECT_STREAM.getMarker(), "RunningHashCalculatorForStream :: setRunningHash: {}", (Object)hash);
    }

    @Override
    public void addObject(T t) {
        if (((SerializableHashable)t).getHash() == null) {
            this.cryptography.digestSync((SerializableHashable)t);
        }
        Hash newHashToAdd = ((SerializableHashable)t).getHash();
        this.runningHash = this.cryptography.calcRunningHash(this.runningHash, newHashToAdd, DigestType.SHA_384);
        t.getRunningHash().setHash(this.runningHash);
        super.addObject(t);
    }

    @Override
    public void close() {
        super.close();
        LOGGER.info(LogMarker.OBJECT_STREAM.getMarker(), "RunningHashCalculatorForStream is closed");
    }

    public Hash getRunningHash() {
        return this.runningHash;
    }
}

