/*
 * Decompiled with CFR 0.152.
 */
package com.swirlds.common.system.events;

import com.swirlds.common.io.SelfSerializable;
import com.swirlds.common.io.streams.SerializableDataInputStream;
import com.swirlds.common.io.streams.SerializableDataOutputStream;
import com.swirlds.common.utility.CommonUtils;
import java.io.IOException;
import org.apache.commons.lang3.builder.EqualsBuilder;
import org.apache.commons.lang3.builder.HashCodeBuilder;

public class BaseEventUnhashedData
implements SelfSerializable {
    private static final long CLASS_ID = 3732249661177372305L;
    private static final int CLASS_VERSION = 1;
    private static final int MAX_SIG_LENGTH = 384;
    private static final long SEQUENCE_UNUSED = -1L;
    private long creatorSeq;
    private long otherId;
    private long otherSeq;
    private byte[] signature;

    public BaseEventUnhashedData() {
    }

    public BaseEventUnhashedData(long otherId, byte[] signature) {
        this.creatorSeq = -1L;
        this.otherId = otherId;
        this.signature = signature;
        this.otherSeq = -1L;
    }

    @Override
    public void serialize(SerializableDataOutputStream out) throws IOException {
        out.writeLong(this.creatorSeq);
        out.writeLong(this.otherId);
        out.writeLong(this.otherSeq);
        out.writeByteArray(this.signature);
    }

    @Override
    public void deserialize(SerializableDataInputStream in, int version) throws IOException {
        this.creatorSeq = in.readLong();
        this.otherId = in.readLong();
        this.otherSeq = in.readLong();
        this.signature = in.readByteArray(384);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        BaseEventUnhashedData that = (BaseEventUnhashedData)o;
        return new EqualsBuilder().append(this.creatorSeq, that.creatorSeq).append(this.otherId, that.otherId).append(this.otherSeq, that.otherSeq).append(this.signature, that.signature).isEquals();
    }

    public int hashCode() {
        return new HashCodeBuilder(17, 37).append(this.creatorSeq).append(this.otherId).append(this.otherSeq).append(this.signature).toHashCode();
    }

    public String toString() {
        int signatureLength = this.signature == null ? 0 : this.signature.length;
        return "BaseEventUnhashedData{creatorSeq=" + this.creatorSeq + ", otherId=" + this.otherId + ", otherSeq=" + this.otherSeq + ", signature=" + CommonUtils.hex(this.signature, signatureLength) + "}";
    }

    @Override
    public long getClassId() {
        return 3732249661177372305L;
    }

    @Override
    public int getVersion() {
        return 1;
    }

    public long getOtherId() {
        return this.otherId;
    }

    public byte[] getSignature() {
        return this.signature;
    }
}

