/*
 * Decompiled with CFR 0.152.
 */
package com.swirlds.common.system.events;

import com.swirlds.common.crypto.AbstractSerializableHashable;
import com.swirlds.common.io.OptionalSelfSerializable;
import com.swirlds.common.io.streams.SerializableDataInputStream;
import com.swirlds.common.io.streams.SerializableDataOutputStream;
import com.swirlds.common.system.events.BaseEventHashedData;
import com.swirlds.common.system.events.BaseEventUnhashedData;
import com.swirlds.common.system.events.ConsensusData;
import com.swirlds.common.system.events.EventSerializationOptions;
import java.io.IOException;
import org.apache.commons.lang3.builder.EqualsBuilder;
import org.apache.commons.lang3.builder.HashCodeBuilder;
import org.apache.commons.lang3.builder.ToStringBuilder;
import org.apache.commons.lang3.builder.ToStringStyle;

public class ConsensusEvent
extends AbstractSerializableHashable
implements OptionalSelfSerializable<EventSerializationOptions> {
    public static final long CLASS_ID = -2139022923795222086L;
    public static final int CLASS_VERSION = 1;
    private BaseEventHashedData baseEventHashedData;
    private BaseEventUnhashedData baseEventUnhashedData;
    private ConsensusData consensusData;

    public ConsensusEvent() {
    }

    public ConsensusEvent(BaseEventHashedData baseEventHashedData, BaseEventUnhashedData baseEventUnhashedData, ConsensusData consensusData) {
        this.baseEventHashedData = baseEventHashedData;
        this.baseEventUnhashedData = baseEventUnhashedData;
        this.consensusData = consensusData;
    }

    @Override
    public void serialize(SerializableDataOutputStream out, EventSerializationOptions option) throws IOException {
        ConsensusEvent.serialize(out, this.baseEventHashedData, this.baseEventUnhashedData, this.consensusData, option);
    }

    public static void serialize(SerializableDataOutputStream out, BaseEventHashedData baseEventHashedData, BaseEventUnhashedData baseEventUnhashedData, ConsensusData consensusData, EventSerializationOptions option) throws IOException {
        out.writeOptionalSerializable(baseEventHashedData, false, option);
        out.writeSerializable(baseEventUnhashedData, false);
        out.writeSerializable(consensusData, false);
    }

    @Override
    public void serialize(SerializableDataOutputStream out) throws IOException {
        ConsensusEvent.serialize(out, this.baseEventHashedData, this.baseEventUnhashedData, this.consensusData, EventSerializationOptions.FULL);
    }

    @Override
    public void deserialize(SerializableDataInputStream in, int version) throws IOException {
        this.baseEventHashedData = in.readSerializable(false, BaseEventHashedData::new);
        this.baseEventUnhashedData = in.readSerializable(false, BaseEventUnhashedData::new);
        this.consensusData = in.readSerializable(false, ConsensusData::new);
    }

    public BaseEventHashedData getBaseEventHashedData() {
        return this.baseEventHashedData;
    }

    public BaseEventUnhashedData getBaseEventUnhashedData() {
        return this.baseEventUnhashedData;
    }

    public ConsensusData getConsensusData() {
        return this.consensusData;
    }

    @Override
    public long getClassId() {
        return -2139022923795222086L;
    }

    @Override
    public int getVersion() {
        return 1;
    }

    public int hashCode() {
        return new HashCodeBuilder().append(this.baseEventHashedData.hashCode()).append(this.baseEventUnhashedData.hashCode()).append(this.consensusData.hashCode()).build();
    }

    public boolean equals(Object obj) {
        if (obj == null || obj.getClass() != this.getClass()) {
            return false;
        }
        if (this == obj) {
            return true;
        }
        ConsensusEvent that = (ConsensusEvent)obj;
        return new EqualsBuilder().append((Object)this.baseEventHashedData, (Object)that.baseEventHashedData).append((Object)this.baseEventUnhashedData, (Object)that.baseEventUnhashedData).append((Object)this.consensusData, (Object)that.consensusData).isEquals();
    }

    public String toString() {
        return new ToStringBuilder((Object)this, ToStringStyle.SHORT_PREFIX_STYLE).append("baseEventHashedData", (Object)this.baseEventHashedData).append("baseEventUnhashedData", (Object)this.baseEventUnhashedData).append("consensusData", (Object)this.consensusData).toString();
    }
}

