/*
 * Decompiled with CFR 0.152.
 */
package com.swirlds.common.system.transaction;

import com.swirlds.common.crypto.SignatureType;
import com.swirlds.common.crypto.TransactionSignature;
import com.swirlds.common.internal.SettingsCommon;
import com.swirlds.common.io.streams.AugmentedDataOutputStream;
import com.swirlds.common.io.streams.SerializableDataInputStream;
import com.swirlds.common.io.streams.SerializableDataOutputStream;
import com.swirlds.common.system.transaction.Transaction;
import com.swirlds.common.system.transaction.TransactionType;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;

public class SwirldTransaction
implements Comparable<SwirldTransaction>,
Transaction {
    private static final long CLASS_ID = -6919902293613290601L;
    private static final int CLASS_VERSION = 1;
    private static final String CONTENT_ERROR = "content is null or length is 0";
    private static final int DEFAULT_SIGNATURE_LIST_SIZE = 5;
    private final ReadWriteLock readWriteLock;
    private byte[] contents;
    private List<TransactionSignature> signatures;

    public SwirldTransaction() {
        this.readWriteLock = new ReentrantReadWriteLock(false);
    }

    public SwirldTransaction(byte[] contents) {
        if (contents == null || contents.length == 0) {
            throw new IllegalArgumentException(CONTENT_ERROR);
        }
        this.contents = (byte[])contents.clone();
        this.readWriteLock = new ReentrantReadWriteLock(false);
    }

    @Override
    public void serialize(SerializableDataOutputStream out) throws IOException {
        out.writeByteArray(this.contents);
    }

    @Override
    public void deserialize(SerializableDataInputStream in, int version) throws IOException {
        this.contents = in.readByteArray(SettingsCommon.transactionMaxBytes);
    }

    public byte[] getContents() {
        if (this.contents == null || this.contents.length == 0) {
            throw new IllegalArgumentException(CONTENT_ERROR);
        }
        return (byte[])this.contents.clone();
    }

    public byte getContents(int index) {
        if (this.contents == null || this.contents.length == 0) {
            throw new IllegalArgumentException(CONTENT_ERROR);
        }
        if (index < 0 || index >= this.contents.length) {
            throw new ArrayIndexOutOfBoundsException();
        }
        return this.contents[index];
    }

    public byte[] getContentsDirect() {
        return this.contents;
    }

    public int getLength() {
        return this.contents != null ? this.contents.length : 0;
    }

    public int size() {
        return this.getLength();
    }

    public List<TransactionSignature> getSignatures() {
        Lock readLock = this.readWriteLock.readLock();
        try {
            readLock.lock();
            ArrayList<TransactionSignature> arrayList = this.signatures != null ? new ArrayList<TransactionSignature>(this.signatures) : Collections.emptyList();
            return arrayList;
        }
        finally {
            readLock.unlock();
        }
    }

    public void extractSignature(int signatureOffset, int signatureLength, int publicKeyOffset, int publicKeyLength, int messageOffset, int messageLength) {
        this.add(new TransactionSignature(this.contents, signatureOffset, signatureLength, publicKeyOffset, publicKeyLength, messageOffset, messageLength));
    }

    public void extractSignature(int signatureOffset, int signatureLength, int publicKeyOffset, int publicKeyLength, int messageOffset, int messageLength, SignatureType sigType) {
        this.add(new TransactionSignature(this.contents, signatureOffset, signatureLength, publicKeyOffset, publicKeyLength, messageOffset, messageLength, sigType));
    }

    public void extractSignature(int signatureOffset, int signatureLength, byte[] expandedPublicKey, int publicKeyOffset, int publicKeyLength, int messageOffset, int messageLength) {
        this.add(new TransactionSignature(this.contents, signatureOffset, signatureLength, expandedPublicKey, publicKeyOffset, publicKeyLength, messageOffset, messageLength));
    }

    public void add(TransactionSignature signature) {
        if (signature == null) {
            throw new IllegalArgumentException("signature");
        }
        Lock writeLock = this.readWriteLock.writeLock();
        try {
            writeLock.lock();
            if (this.signatures == null) {
                this.signatures = new ArrayList<TransactionSignature>(5);
            }
            this.signatures.add(signature);
        }
        finally {
            writeLock.unlock();
        }
    }

    public void addAll(TransactionSignature ... signatures) {
        if (signatures == null || signatures.length == 0) {
            return;
        }
        Lock writeLock = this.readWriteLock.writeLock();
        try {
            writeLock.lock();
            if (this.signatures == null) {
                this.signatures = new ArrayList<TransactionSignature>(signatures.length);
            }
            this.signatures.addAll(Arrays.asList(signatures));
        }
        finally {
            writeLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean remove(TransactionSignature signature) {
        if (signature == null) {
            return false;
        }
        Lock writeLock = this.readWriteLock.writeLock();
        try {
            writeLock.lock();
            if (this.signatures == null) {
                boolean bl = false;
                return bl;
            }
            boolean bl = this.signatures.remove(signature);
            return bl;
        }
        finally {
            writeLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean removeAll(TransactionSignature ... signatures) {
        if (signatures == null || signatures.length == 0) {
            return false;
        }
        Lock writeLock = this.readWriteLock.writeLock();
        try {
            writeLock.lock();
            if (this.signatures == null) {
                boolean bl = false;
                return bl;
            }
            boolean bl = this.signatures.removeAll(Arrays.asList(signatures));
            return bl;
        }
        finally {
            writeLock.unlock();
        }
    }

    public void clearSignatures() {
        Lock writeLock = this.readWriteLock.writeLock();
        try {
            writeLock.lock();
            if (this.signatures == null) {
                return;
            }
            this.signatures = null;
        }
        finally {
            writeLock.unlock();
        }
    }

    public int hashCode() {
        return Arrays.hashCode(this.contents);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof SwirldTransaction)) {
            return false;
        }
        SwirldTransaction that = (SwirldTransaction)obj;
        return Arrays.equals(this.contents, that.contents);
    }

    @Override
    public int compareTo(SwirldTransaction that) {
        if (this == that) {
            return 0;
        }
        if (that == null) {
            throw new IllegalArgumentException();
        }
        return Arrays.compare(this.contents, that.contents);
    }

    public String toString() {
        return "Transaction{contents=" + Arrays.toString(this.contents) + ", signatures=" + this.signatures + "}";
    }

    @Override
    public long getClassId() {
        return -6919902293613290601L;
    }

    @Override
    public int getVersion() {
        return 1;
    }

    @Override
    public int getSerializedLength() {
        return AugmentedDataOutputStream.getArraySerializedLength(this.contents);
    }

    @Override
    public int getSize() {
        return this.contents == null ? 0 : this.contents.length;
    }

    @Override
    public TransactionType getTransactionType() {
        return TransactionType.APPLICATION;
    }
}

