/*
 * Decompiled with CFR 0.152.
 */
package com.swirlds.common.threading.framework.config;

import com.swirlds.common.threading.framework.ThreadSeed;
import com.swirlds.common.threading.framework.internal.AbstractThreadConfiguration;
import java.util.concurrent.ThreadFactory;

public class ThreadConfiguration
extends AbstractThreadConfiguration<ThreadConfiguration> {
    public ThreadConfiguration() {
    }

    private ThreadConfiguration(ThreadConfiguration that) {
        super(that);
    }

    @Override
    public ThreadConfiguration copy() {
        return new ThreadConfiguration(this);
    }

    public static ThreadConfiguration captureThreadConfiguration() {
        return ThreadConfiguration.captureThreadConfiguration(Thread.currentThread());
    }

    public static ThreadConfiguration captureThreadConfiguration(Thread thread) {
        ThreadConfiguration configuration = new ThreadConfiguration();
        configuration.copyThreadConfiguration(thread);
        return configuration;
    }

    public Thread build() {
        return this.build(false);
    }

    public Thread build(boolean start) {
        this.becomeImmutable();
        return this.buildThread(start);
    }

    public ThreadFactory buildFactory() {
        this.enableThreadNumbering();
        ThreadFactory factory = r -> {
            Thread thread = new Thread(this.getThreadGroup(), r);
            this.configureThread(thread);
            return thread;
        };
        this.becomeImmutable();
        return factory;
    }

    public ThreadSeed buildSeed() {
        this.becomeImmutable();
        return this.buildThreadSeed();
    }

    @Override
    public Runnable getRunnable() {
        return super.getRunnable();
    }

    @Override
    public ThreadConfiguration setRunnable(Runnable runnable) {
        return (ThreadConfiguration)super.setRunnable(runnable);
    }
}

