/*
 * Decompiled with CFR 0.152.
 */
package com.swirlds.common.threading.futures;

import java.util.concurrent.CancellationException;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;

public class WaitingFuture<T>
implements Future<T> {
    private volatile boolean done = false;
    private volatile boolean cancelled = false;
    private volatile T value;
    private final CountDownLatch latch = new CountDownLatch(1);

    public WaitingFuture() {
    }

    public WaitingFuture(T value) {
        this();
        this.value = value;
        this.done = true;
        this.latch.countDown();
    }

    @Override
    public boolean cancel(boolean mayInterruptIfRunning) {
        this.cancel();
        return !this.isDone();
    }

    @Override
    public boolean isCancelled() {
        return this.cancelled;
    }

    @Override
    public boolean isDone() {
        return this.done;
    }

    @Override
    public T get() throws InterruptedException {
        this.latch.await();
        if (this.cancelled) {
            throw new CancellationException();
        }
        return this.value;
    }

    @Override
    public T get(long timeout, TimeUnit unit) throws InterruptedException {
        this.latch.await(timeout, unit);
        if (this.cancelled) {
            throw new CancellationException();
        }
        return this.value;
    }

    public void done(T value) {
        this.value = value;
        this.done = true;
        this.latch.countDown();
    }

    public void cancel() {
        this.cancelled = true;
        this.done = false;
        this.latch.countDown();
    }
}

