/*
 * Decompiled with CFR 0.152.
 */
package com.swirlds.common.config;

import com.swirlds.common.constructable.URLClassLoaderWithLookup;
import com.swirlds.config.api.ConfigData;
import com.swirlds.config.api.ConfigurationBuilder;
import io.github.classgraph.ClassGraph;
import io.github.classgraph.ClassInfoList;
import io.github.classgraph.ScanResult;

public final class ConfigurationUtils {
    private ConfigurationUtils() {
    }

    public static void scanAndRegisterAllConfigTypes(ConfigurationBuilder configurationBuilder, String packagePrefix, URLClassLoaderWithLookup ... additionalClassLoaders) {
        ClassGraph classGraph = new ClassGraph().enableAnnotationInfo().whitelistPackages(new String[]{packagePrefix});
        if (additionalClassLoaders != null) {
            for (URLClassLoaderWithLookup classloader : additionalClassLoaders) {
                classGraph.addClassLoader((ClassLoader)classloader);
            }
        }
        try (ScanResult result = classGraph.scan();){
            ClassInfoList classInfos = result.getClassesWithAnnotation(ConfigData.class.getName());
            classInfos.stream().map(classInfo -> classInfo.loadClass()).forEach(arg_0 -> ((ConfigurationBuilder)configurationBuilder).withConfigDataType(arg_0));
        }
    }
}

